/*
 * Decompiled with CFR 0.152.
 */
package com.github.chen0040.gp.treegp.gp;

import com.github.chen0040.gp.treegp.TreeGP;
import com.github.chen0040.gp.treegp.enums.TGPInitializationStrategy;
import com.github.chen0040.gp.treegp.program.Program;
import com.github.chen0040.gp.treegp.program.Solution;
import java.util.List;

public class PopulationInitialization {
    public static void apply(List<Solution> solutions, TreeGP programManager) {
        TGPInitializationStrategy initializationStrategy = programManager.getPopulationInitializationStrategy();
        if (initializationStrategy == TGPInitializationStrategy.INITIALIZATION_METHOD_FULL || initializationStrategy == TGPInitializationStrategy.INITIALIZATION_METHOD_GROW || initializationStrategy == TGPInitializationStrategy.INITIALIZATION_METHOD_PTC1 || initializationStrategy == TGPInitializationStrategy.INITIALIZATION_METHOD_RANDOM_BRANCH) {
            PopulationInitialization.initializeNotRamped(solutions, programManager);
        } else if (initializationStrategy == TGPInitializationStrategy.INITIALIZATION_METHOD_RAMPED_FULL || initializationStrategy == TGPInitializationStrategy.INITIALIZATION_METHOD_RAMPED_GROW) {
            PopulationInitialization.initializeRamped(solutions, programManager);
        } else if (initializationStrategy == TGPInitializationStrategy.INITIALIZATION_METHOD_RAMPED_HALF_HALF) {
            PopulationInitialization.initializeRampedHalfHalf(solutions, programManager);
        }
    }

    private static void initializeRampedHalfHalf(List<Solution> solutions, TreeGP programManager) {
        int pop_count;
        Solution solution;
        int populationSize = programManager.getPopulationSize();
        int maxDepthForCreation = programManager.getMaxDepthForCreation();
        int part_count = maxDepthForCreation - 1;
        int interval = populationSize / part_count;
        int interval2 = interval / 2;
        for (int i = 0; i < part_count; ++i) {
            int j;
            for (j = 0; j < interval2; ++j) {
                solution = PopulationInitialization.createSolution(programManager, i + 2, TGPInitializationStrategy.INITIALIZATION_METHOD_GROW);
                solutions.add(solution);
            }
            for (j = interval2; j < interval; ++j) {
                solution = PopulationInitialization.createSolution(programManager, i + 2, TGPInitializationStrategy.INITIALIZATION_METHOD_FULL);
                solutions.add(solution);
            }
        }
        for (int i = pop_count = solutions.size(); i < populationSize; ++i) {
            solution = PopulationInitialization.createSolution(programManager, maxDepthForCreation, TGPInitializationStrategy.INITIALIZATION_METHOD_GROW);
            solutions.add(solution);
        }
    }

    private static void initializeRamped(List<Solution> solutions, TreeGP programManager) {
        int pop_count;
        Solution solution;
        int populationSize = programManager.getPopulationSize();
        int maxDepthForCreation = programManager.getMaxDepthForCreation();
        int part_count = maxDepthForCreation - 1;
        int interval = populationSize / part_count;
        TGPInitializationStrategy method = programManager.getPopulationInitializationStrategy();
        if (method == TGPInitializationStrategy.INITIALIZATION_METHOD_RAMPED_FULL) {
            method = TGPInitializationStrategy.INITIALIZATION_METHOD_FULL;
        } else if (method == TGPInitializationStrategy.INITIALIZATION_METHOD_RAMPED_GROW) {
            method = TGPInitializationStrategy.INITIALIZATION_METHOD_GROW;
        }
        for (int i = 0; i < part_count; ++i) {
            for (int j = 0; j < interval; ++j) {
                solution = PopulationInitialization.createSolution(programManager, i + 1, method);
                solutions.add(solution);
            }
        }
        for (int i = pop_count = solutions.size(); i < populationSize; ++i) {
            solution = PopulationInitialization.createSolution(programManager, maxDepthForCreation, method);
            solutions.add(solution);
        }
    }

    private static void initializeNotRamped(List<Solution> solutions, TreeGP programManager) {
        int iPopulationSize = programManager.getPopulationSize();
        for (int i = 0; i < iPopulationSize; ++i) {
            Solution solution = PopulationInitialization.createSolution(programManager, programManager.getMaxDepthForCreation(), programManager.getPopulationInitializationStrategy());
            solutions.add(solution);
        }
    }

    private static Solution createSolution(TreeGP programManager, int maxDepth, TGPInitializationStrategy initializationStrategy) {
        int treeCount = programManager.getTreeCountPerSolution();
        return new Solution(treeCount, index -> {
            Program tree = new Program();
            tree.createWithDepth(maxDepth, programManager, initializationStrategy);
            return tree;
        });
    }
}

