/*
 * Decompiled with CFR 0.152.
 */
package com.github.chen0040.gp.treegp.program;

import com.github.chen0040.gp.commons.EntityContainer;
import com.github.chen0040.gp.services.RandEngine;
import com.github.chen0040.gp.treegp.program.Primitive;
import com.github.chen0040.gp.treegp.program.operators.IfGreaterThan;
import com.github.chen0040.gp.treegp.program.operators.IfLessThan;
import java.io.Serializable;
import java.util.ArrayList;

public class OperatorSet
extends EntityContainer<Primitive>
implements Serializable {
    private static final long serialVersionUID = -6660969377144991417L;

    public boolean isReadOnly() {
        return false;
    }

    public OperatorSet makeCopy() {
        OperatorSet clone = new OperatorSet();
        clone.copy(this);
        return clone;
    }

    public void addIfLessThanOperator() {
        this.addIfLessThanOperator(1.0);
    }

    public void addIfLessThanOperator(double weight) {
        this.add(new IfLessThan(), weight);
    }

    public void addIfGreaterThanOperator() {
        this.addIfGreaterThanOperator(1.0);
    }

    public void addIfGreaterThanOperator(double weight) {
        this.add(new IfGreaterThan(), weight);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.entities.size(); ++i) {
            if (i != 0) {
                sb.append("\r\n");
            }
            sb.append("operator[").append(i).append("]: ").append(this.entities.get(i));
        }
        return sb.toString();
    }

    public Primitive anyOther(int arity, Primitive excluded, RandEngine rand) {
        ArrayList<Primitive> candidates = new ArrayList<Primitive>();
        double weightSum = 0.0;
        for (int i = 0; i < this.entities.size(); ++i) {
            Primitive op = (Primitive)this.entities.get(i);
            if (op.arity() != arity) continue;
            weightSum += ((Double)this.weights.get(op.getIndex())).doubleValue();
            candidates.add(op);
        }
        block1: for (int attempts = 0; attempts < 10; ++attempts) {
            double r = weightSum * rand.uniform();
            double accSum = 0.0;
            for (int i = 0; i < candidates.size(); ++i) {
                Primitive op = (Primitive)candidates.get(i);
                if (!(r <= (accSum += ((Double)this.weights.get(op.getIndex())).doubleValue()))) continue;
                if (op == excluded) continue block1;
                return op;
            }
        }
        return excluded;
    }

    public Primitive anyWithArityLessThan(int maxArity, RandEngine randEngine) {
        ArrayList<Primitive> ops = new ArrayList<Primitive>();
        for (int i = 0; i < this.entities.size(); ++i) {
            Primitive op1 = (Primitive)this.entities.get(i);
            if (op1.arity() >= maxArity) continue;
            ops.add(op1);
        }
        if (ops.isEmpty()) {
            return null;
        }
        return (Primitive)ops.get(randEngine.nextInt(ops.size()));
    }
}

