/*
 * Decompiled with CFR 0.152.
 */
package com.github.chen0040.gp.treegp.program;

import com.github.chen0040.data.utils.StringUtils;
import com.github.chen0040.gp.commons.Indexable;
import com.github.chen0040.gp.exceptions.SizeMismatchedException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public abstract class Primitive
implements Serializable,
Indexable<Primitive> {
    private static final long serialVersionUID = -249257238928605728L;
    private final List<Double> inputs = new ArrayList<Double>();
    private double value;
    private final String symbol;
    private final boolean readOnly;
    private int index;

    public Primitive() {
        this.symbol = "";
        this.readOnly = false;
    }

    public Primitive(int inputCount, String symbol, double value, boolean readOnly) {
        for (int i = 0; i < inputCount; ++i) {
            this.inputs.add(0.0);
        }
        this.symbol = symbol;
        this.value = value;
        this.readOnly = readOnly;
    }

    public boolean isTerminal() {
        return this.inputs.isEmpty();
    }

    @Override
    public String getName() {
        if (StringUtils.isEmpty((String)this.symbol)) {
            return (this.isReadOnly() ? "c" : "v") + this.index;
        }
        return this.symbol;
    }

    public Primitive copy(Primitive that) {
        if (!this.symbol.equals(that.getSymbol())) {
            throw new RuntimeException("Symbol not matched for copy to proceed");
        }
        this.inputs.clear();
        for (int i = 0; i < that.inputs.size(); ++i) {
            this.inputs.add(that.inputs.get(i));
        }
        this.value = that.value;
        this.index = that.index;
        return this;
    }

    public int arity() {
        return this.inputs.size();
    }

    public void read(List<Double> values) {
        if (this.inputs.size() != values.size()) {
            throw new SizeMismatchedException(this.inputs.size(), values.size());
        }
        for (int i = 0; i < values.size(); ++i) {
            this.inputs.set(i, values.get(i));
        }
    }

    public void setInput(int index, double value) {
        if (index >= this.arity()) {
            throw new IndexOutOfBoundsException(index + " is greater or equal to input size" + this.arity());
        }
        this.inputs.set(index, value);
    }

    public double getInput(int index) {
        if (index >= this.arity()) {
            throw new IndexOutOfBoundsException(index + " is greater or equal to input size" + this.arity());
        }
        return this.inputs.get(index);
    }

    public void setValue(double val) {
        if (this.readOnly) {
            throw new RuntimeException("The primitive is readonly");
        }
        this.value = val;
    }

    public double getValue() {
        return this.value;
    }

    public String getSymbol() {
        return this.symbol;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    @Override
    public int getIndex() {
        return this.index;
    }

    @Override
    public void setIndex(int index) {
        this.index = index;
    }

    @Override
    public abstract Primitive makeCopy();

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Primitive primitive = (Primitive)o;
        if (this.readOnly != primitive.readOnly) {
            return false;
        }
        if (this.index != primitive.index) {
            return false;
        }
        return this.symbol != null ? this.symbol.equals(primitive.symbol) : primitive.symbol == null;
    }

    public int hashCode() {
        int result = 0;
        result = 31 * result + (this.symbol != null ? this.symbol.hashCode() : 0);
        result = 31 * result + (this.readOnly ? 1 : 0);
        result = 31 * result + this.index;
        return result;
    }

    public abstract void execute(Object ... var1);
}

