/*
 * Decompiled with CFR 0.152.
 */
package com.github.chen0040.gp.treegp.program;

import com.github.chen0040.gp.treegp.program.ConstantSet;
import com.github.chen0040.gp.treegp.program.OperatorSet;
import com.github.chen0040.gp.treegp.program.Primitive;
import com.github.chen0040.gp.treegp.program.VariableSet;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class TreeNode
implements Serializable {
    private static final long serialVersionUID = 350057284330815219L;
    private Primitive primitive;
    private final List<TreeNode> children = new ArrayList<TreeNode>();

    public TreeNode(Primitive primitive) {
        assert (primitive != null);
        this.primitive = primitive;
    }

    public TreeNode() {
    }

    public int arity() {
        return this.primitive.arity();
    }

    public int length() {
        int lengthSoFar = 1;
        for (TreeNode node : this.children) {
            lengthSoFar += node.length();
        }
        return lengthSoFar;
    }

    public int depth() {
        return TreeNode.depth(this, 0);
    }

    private static int depth(TreeNode node, int depthSoFar) {
        int maxDepth = depthSoFar;
        for (TreeNode child : node.children) {
            int depth = TreeNode.depth(child, depthSoFar + 1);
            maxDepth = Math.max(maxDepth, depth);
        }
        return maxDepth;
    }

    public double execute(Object ... tags) {
        int count = this.arity();
        ArrayList<Double> inputs = new ArrayList<Double>();
        for (int i = 0; i < count; ++i) {
            inputs.add(this.children.get(i).execute(tags));
        }
        this.primitive.read(inputs);
        this.primitive.execute(tags);
        return this.primitive.getValue();
    }

    public TreeNode makeCopy(OperatorSet operatorSet, VariableSet variableSet, ConstantSet constantSet) {
        TreeNode clone = new TreeNode();
        clone.copy(this, operatorSet, variableSet, constantSet);
        return clone;
    }

    public void copy(TreeNode that, OperatorSet operatorSet, VariableSet variableSet, ConstantSet constantSet) {
        this.primitive = that.primitive.isTerminal() ? (that.primitive.isReadOnly() ? (Primitive)constantSet.get(that.primitive.getIndex()) : (Primitive)variableSet.get(that.primitive.getIndex())) : (Primitive)operatorSet.get(that.primitive.getIndex());
        this.children.clear();
        for (TreeNode child : that.children) {
            this.children.add(child.makeCopy(operatorSet, variableSet, constantSet));
        }
    }

    public boolean isTerminal() {
        return this.primitive.isTerminal();
    }

    public String toString() {
        if (this.primitive.isTerminal()) {
            return this.primitive.toString();
        }
        StringBuilder sb = new StringBuilder();
        sb.append("(").append(this.primitive.getSymbol());
        for (int i = 0; i < this.arity(); ++i) {
            if (i != 0) {
                sb.append(", ");
            }
            sb.append(this.children.get(i));
        }
        sb.append(")");
        return sb.toString();
    }

    public String mathExpression() {
        if (this.primitive.isTerminal()) {
            return this.primitive.toString();
        }
        int arity = this.arity();
        StringBuilder sb = new StringBuilder();
        if (arity == 1) {
            sb.append(this.primitive.getSymbol()).append("(").append(this.children.get(0).mathExpression()).append(")");
        } else if (arity == 2) {
            if (this.children.get(0).isTerminal()) {
                sb.append(this.children.get(0).mathExpression());
            } else {
                sb.append("(").append(this.children.get(0).mathExpression()).append(")");
            }
            sb.append(" ").append(this.primitive.getSymbol()).append(" ");
            if (this.children.get(1).isTerminal()) {
                sb.append(this.children.get(1).mathExpression());
            } else {
                sb.append("(").append(this.children.get(1).mathExpression()).append(")");
            }
        } else if (arity == 4) {
            String symbol = this.primitive.getSymbol();
            if (symbol.equals("if<") || symbol.equals("if>")) {
                sb.append("if(").append(this.children.get(0).mathExpression()).append(symbol.equals("if<") ? " < " : " > ").append(this.children.get(1).mathExpression()).append(", ").append(this.children.get(2).mathExpression()).append(", ").append(this.children.get(3).mathExpression()).append(")");
            } else {
                sb.append("(").append(symbol);
                sb.append(" ");
                for (int i = 0; i < arity; ++i) {
                    if (i != 0) {
                        sb.append(", ");
                    }
                    sb.append(this.children.get(i).mathExpression());
                }
                sb.append(")");
            }
        } else {
            sb.append("(").append(this.primitive.getSymbol());
            sb.append(" ");
            for (int i = 0; i < arity; ++i) {
                if (i != 0) {
                    sb.append(", ");
                }
                sb.append(this.children.get(i).mathExpression());
            }
            sb.append(")");
        }
        return sb.toString();
    }

    public List<Primitive> flatten() {
        ArrayList<Primitive> result = new ArrayList<Primitive>();
        this.collect(this, result);
        return result;
    }

    private void collect(TreeNode node, List<Primitive> list) {
        list.add(node.primitive);
        for (TreeNode child : node.children) {
            this.collect(child, list);
        }
    }

    public int depth2Node(TreeNode node) {
        return TreeNode.depth2Node(this, node, 0);
    }

    public static int depth2Node(TreeNode node, TreeNode target, int depthSoFar) {
        if (node == target) {
            return depthSoFar;
        }
        int maxDepthOfChild = -1;
        for (TreeNode child_node : node.children) {
            int d = TreeNode.depth2Node(child_node, target, depthSoFar + 1);
            if (d <= maxDepthOfChild) continue;
            maxDepthOfChild = d;
        }
        return maxDepthOfChild;
    }

    public Primitive getPrimitive() {
        return this.primitive;
    }

    public List<TreeNode> getChildren() {
        return this.children;
    }

    public void setPrimitive(Primitive primitive) {
        this.primitive = primitive;
    }
}

