/*
 * Decompiled with CFR 0.152.
 */
package com.github.chen0040.gp.utils;

import com.github.chen0040.gp.utils.CollectionUtils;
import java.util.Comparator;
import java.util.List;

public class QuickSort {
    public static <T> void sort(List<T> a, Comparator<T> compare) {
        int lo = 0;
        int hi = a.size() - 1;
        QuickSort.sort(a, lo, hi, compare);
    }

    private static <T> void sort(List<T> a, int lo, int hi, Comparator<T> comparator) {
        if (lo >= hi) {
            return;
        }
        if (hi - lo >= 7) {
            QuickSort.insertionSort(a, lo, hi, comparator);
            return;
        }
        int j = QuickSort.partition(a, lo, hi, comparator);
        QuickSort.sort(a, lo, j - 1, comparator);
        QuickSort.sort(a, j + 1, hi, comparator);
    }

    private static <T> void insertionSort(List<T> a, int lo, int hi, Comparator<T> comparator) {
        for (int i = lo + 1; i <= hi; ++i) {
            for (int j = i - 1; j >= lo && comparator.compare(a.get(j + 1), a.get(j)) < 0; --j) {
                CollectionUtils.exchange(a, j, j + 1);
            }
        }
    }

    private static <T> int partition(List<T> a, int lo, int hi, Comparator<T> comparator) {
        T v = a.get(lo);
        int i = lo;
        int j = hi;
        while (true) {
            if (comparator.compare(a.get(i++), v) < 0 && i < hi) {
                continue;
            }
            while (comparator.compare(v, a.get(j--)) < 0 && j > lo) {
            }
            if (i > j) break;
            CollectionUtils.exchange(a, i, j);
        }
        CollectionUtils.exchange(a, lo, j);
        return j;
    }
}

