/*
 * Decompiled with CFR 0.152.
 */
package com.github.chen0040.gp.commons;

import com.github.chen0040.gp.commons.Indexable;
import com.github.chen0040.gp.services.RandEngine;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class EntityContainer<T extends Indexable<T>>
implements Serializable {
    private static final long serialVersionUID = 1564461409545848260L;
    protected final List<T> entities = new ArrayList<T>();
    protected final List<Double> weights = new ArrayList<Double>();
    protected final Map<String, Integer> names = new HashMap<String, Integer>();

    public double weightSum() {
        if (this.weights.isEmpty()) {
            return 0.0;
        }
        double sum = 0.0;
        for (Double weight : this.weights) {
            sum += weight.doubleValue();
        }
        return sum;
    }

    public T anyOther(T excluded, RandEngine rand) {
        double weightSum = this.weightSum();
        block0: for (int attempts = 0; attempts < 10; ++attempts) {
            double r = weightSum * rand.uniform();
            double accSum = 0.0;
            for (int i = 0; i < this.entities.size(); ++i) {
                if (!(r <= (accSum += this.weights.get(i).doubleValue()))) continue;
                if (this.entities.get(i) == excluded) continue block0;
                return (T)((Indexable)this.entities.get(i));
            }
        }
        return excluded;
    }

    public T get(int index) {
        return (T)((Indexable)this.entities.get(index));
    }

    public T get(String name) {
        if (!this.names.containsKey(name)) {
            return null;
        }
        return (T)((Indexable)this.entities.get(this.names.get(name)));
    }

    public int size() {
        return this.entities.size();
    }

    public void add(T entity, double weight) {
        entity.setIndex(this.entities.size());
        this.entities.add(entity);
        this.weights.add(weight);
        this.names.put(entity.getName(), entity.getIndex());
    }

    public void add(T entity) {
        this.add(entity, 1.0);
    }

    public void copy(EntityContainer<T> that) {
        this.entities.clear();
        this.weights.clear();
        this.names.clear();
        for (int i = 0; i < that.entities.size(); ++i) {
            this.entities.add(((Indexable)that.entities.get(i)).makeCopy());
            this.weights.add(that.weights.get(i));
        }
        this.names.putAll(that.names);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !(o instanceof EntityContainer)) {
            return false;
        }
        EntityContainer that = (EntityContainer)o;
        if (this.entities.size() != that.entities.size()) {
            return false;
        }
        for (int i = 0; i < this.entities.size(); ++i) {
            if (((Indexable)this.entities.get(i)).equals(that.entities.get(i))) continue;
            return false;
        }
        return this.weights.equals(that.weights);
    }

    public int hashCode() {
        int result = this.entities.hashCode();
        result = 31 * result + this.weights.hashCode();
        return result;
    }

    public T any(RandEngine randEngine) {
        return this.anyOther(null, randEngine);
    }

    public double getWeight(int index) {
        return this.weights.get(index);
    }

    public void addAll(T ... entities) {
        for (int i = 0; i < entities.length; ++i) {
            this.add(entities[i]);
        }
    }
}

