/*
 * Decompiled with CFR 0.152.
 */
package com.github.chen0040.gp.treegp.gp;

import com.github.chen0040.data.utils.TupleTwo;
import com.github.chen0040.gp.services.RandEngine;
import com.github.chen0040.gp.treegp.TreeGP;
import com.github.chen0040.gp.treegp.enums.TGPCrossoverStrategy;
import com.github.chen0040.gp.treegp.program.Primitive;
import com.github.chen0040.gp.treegp.program.Program;
import com.github.chen0040.gp.treegp.program.Solution;
import com.github.chen0040.gp.treegp.program.TreeNode;
import java.util.ArrayList;

public class Crossover {
    public static void apply(Program program1, Program program2, TreeGP manager) {
        int iMaxDepthForCrossover = manager.getMaxDepthForCrossover();
        TGPCrossoverStrategy method = manager.getCrossoverStrategy();
        RandEngine randEngine = manager.getRandEngine();
        if (method == TGPCrossoverStrategy.CROSSOVER_SUBTREE_BIAS || method == TGPCrossoverStrategy.CROSSVOER_SUBTREE_NO_BIAS) {
            TupleTwo<TreeNode, TreeNode> pCutPoint2;
            TupleTwo<TreeNode, TreeNode> pCutPoint1;
            boolean bias = method == TGPCrossoverStrategy.CROSSOVER_SUBTREE_BIAS;
            int iMaxDepth1 = program1.calcDepth();
            int iMaxDepth2 = program2.calcDepth();
            boolean is_crossover_performed = false;
            if (iMaxDepth1 <= iMaxDepthForCrossover && iMaxDepth2 <= iMaxDepthForCrossover) {
                int max_trials = 50;
                int trials = 0;
                do {
                    pCutPoint1 = program1.anyNode(bias, randEngine);
                    pCutPoint2 = program2.anyNode(bias, randEngine);
                    if (pCutPoint1 == null || pCutPoint2 == null) continue;
                    TupleTwo<TupleTwo<TreeNode, TreeNode>, TupleTwo<TreeNode, TreeNode>> result = Crossover.swap(program1, program2, pCutPoint1, pCutPoint2);
                    iMaxDepth1 = program1.calcDepth();
                    iMaxDepth2 = program2.calcDepth();
                    if (iMaxDepth1 <= iMaxDepthForCrossover && iMaxDepth2 <= iMaxDepthForCrossover) {
                        is_crossover_performed = true;
                        break;
                    }
                    TupleTwo newCutPoint1 = (TupleTwo)result._1();
                    TupleTwo newCutPoint2 = (TupleTwo)result._2();
                    Crossover.swap(program1, program2, (TupleTwo<TreeNode, TreeNode>)newCutPoint1, (TupleTwo<TreeNode, TreeNode>)newCutPoint2);
                } while (++trials < max_trials);
            }
            if (!is_crossover_performed) {
                pCutPoint1 = program1.anyNode(bias, randEngine);
                pCutPoint2 = program2.anyNode(bias, randEngine);
                if (pCutPoint1 != null && pCutPoint2 != null) {
                    Crossover.swap(program1, program2, pCutPoint1, pCutPoint2);
                    program1.calcLength();
                    program2.calcLength();
                }
            }
        }
    }

    private static TupleTwo<TupleTwo<TreeNode, TreeNode>, TupleTwo<TreeNode, TreeNode>> swap(Program program1, Program program2, TupleTwo<TreeNode, TreeNode> cutPoint1, TupleTwo<TreeNode, TreeNode> cutPoint2) {
        TreeNode parent1 = (TreeNode)cutPoint1._2();
        TreeNode parent2 = (TreeNode)cutPoint2._2();
        TreeNode point1 = (TreeNode)cutPoint1._1();
        TreeNode point2 = (TreeNode)cutPoint2._1();
        if (parent1 == null || parent2 == null) {
            int i;
            Primitive content1 = point1.getPrimitive();
            Primitive content2 = point2.getPrimitive();
            point1.setPrimitive(program1.matchPrimitive(content2));
            point2.setPrimitive(program2.matchPrimitive(content1));
            ArrayList<TreeNode> children1 = new ArrayList<TreeNode>(point1.getChildren());
            ArrayList<TreeNode> children2 = new ArrayList<TreeNode>(point2.getChildren());
            point1.getChildren().clear();
            point2.getChildren().clear();
            for (i = 0; i < children1.size(); ++i) {
                point2.getChildren().add(((TreeNode)children1.get(i)).makeCopy(program2.getOperatorSet(), program2.getVariableSet(), program2.getConstantSet()));
            }
            for (i = 0; i < children2.size(); ++i) {
                point1.getChildren().add(((TreeNode)children2.get(i)).makeCopy(program1.getOperatorSet(), program1.getVariableSet(), program1.getConstantSet()));
            }
            return new TupleTwo(cutPoint1, cutPoint2);
        }
        int child_index1 = parent1.getChildren().indexOf(point1);
        int child_index2 = parent2.getChildren().indexOf(point2);
        TreeNode newChild1 = point2.makeCopy(program1.getOperatorSet(), program1.getVariableSet(), program1.getConstantSet());
        TreeNode newChild2 = point1.makeCopy(program2.getOperatorSet(), program2.getVariableSet(), program2.getConstantSet());
        parent1.getChildren().set(child_index1, newChild1);
        parent2.getChildren().set(child_index2, newChild2);
        return new TupleTwo((Object)new TupleTwo((Object)newChild1, (Object)parent1), (Object)new TupleTwo((Object)newChild2, (Object)parent2));
    }

    public static void apply(Solution solution1, Solution solution2, TreeGP manager) {
        RandEngine randEngine = manager.getRandEngine();
        int tree_count = solution1.getTrees().size();
        for (int i = 0; i < tree_count; ++i) {
            if (tree_count > 1 && randEngine.uniform() < 0.5) {
                Program temp = solution2.getTrees().get(i);
                solution2.getTrees().set(i, solution1.getTrees().get(i));
                solution1.getTrees().set(i, temp);
                continue;
            }
            Crossover.apply(solution1.getTrees().get(i), solution2.getTrees().get(i), manager);
        }
        solution1.invalidateCost();
        solution2.invalidateCost();
    }
}

