/*
 * Decompiled with CFR 0.152.
 */
package com.github.chen0040.gp.treegp.gp;

import com.github.chen0040.gp.services.RandEngine;
import com.github.chen0040.gp.treegp.TreeGP;
import com.github.chen0040.gp.treegp.program.Primitive;
import com.github.chen0040.gp.treegp.program.Program;
import com.github.chen0040.gp.treegp.program.Solution;
import com.github.chen0040.gp.treegp.program.Terminal;
import com.github.chen0040.gp.treegp.program.TreeNode;
import java.util.List;

public class MicroMutation {
    public static void apply(Program program, TreeGP manager) {
        RandEngine randEngine = manager.getRandEngine();
        TreeNode node = (TreeNode)program.anyNode(randEngine)._1();
        if (node.isTerminal()) {
            Terminal terminal = program.anyTerminal(randEngine);
            int trials = 0;
            int max_trials = 50;
            while (node.getPrimitive() == terminal) {
                terminal = program.anyTerminal(randEngine);
                if (++trials <= max_trials) continue;
            }
            if (terminal != null) {
                node.setPrimitive(terminal);
            }
        } else {
            int parameter_count = node.arity();
            Primitive op = program.getOperatorSet().anyOther(parameter_count, node.getPrimitive(), randEngine);
            if (op != null) {
                node.setPrimitive(op);
            }
        }
    }

    public static void apply(Solution solution, TreeGP manager) {
        List<Program> trees = solution.getTrees();
        for (int i = 0; i < trees.size(); ++i) {
            MicroMutation.apply(trees.get(i), manager);
        }
    }
}

