/*
 * Decompiled with CFR 0.152.
 */
package com.github.chen0040.gp.treegp.gp;

import com.github.chen0040.data.utils.TupleTwo;
import com.github.chen0040.gp.commons.TournamentSelection;
import com.github.chen0040.gp.commons.TournamentSelectionResult;
import com.github.chen0040.gp.services.RandEngine;
import com.github.chen0040.gp.treegp.TreeGP;
import com.github.chen0040.gp.treegp.enums.TGPPopulationReplacementStrategy;
import com.github.chen0040.gp.treegp.gp.Crossover;
import com.github.chen0040.gp.treegp.gp.MacroMutation;
import com.github.chen0040.gp.treegp.gp.MicroMutation;
import com.github.chen0040.gp.treegp.gp.PopulationInitialization;
import com.github.chen0040.gp.treegp.program.Solution;
import com.github.chen0040.gp.utils.CollectionUtils;
import com.github.chen0040.gp.utils.QuickSort;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Population {
    private static final Logger logger = LoggerFactory.getLogger(Population.class);
    private final List<Solution> solutions = new ArrayList<Solution>();
    private final TreeGP manager;
    private Optional<Solution> globalBestSolution = Optional.empty();
    private Solution bestSolutionInCurrentGeneration = null;
    private int currentGeneration;

    public Population(TreeGP manager) {
        this.manager = manager;
    }

    protected void evaluate() {
        double bestCost = Double.MAX_VALUE;
        for (int i = 0; i < this.solutions.size(); ++i) {
            Solution p = this.solutions.get(i);
            this.evaluate(p);
            if (!(p.getCost() < bestCost)) continue;
            this.bestSolutionInCurrentGeneration = p;
            bestCost = p.getCost();
        }
        this.updateGlobal(this.bestSolutionInCurrentGeneration);
    }

    private void evaluate(Solution solution) {
        if (solution.isCostValid()) {
            return;
        }
        double cost = this.manager.evaluateCost(solution);
        solution.setCost(cost);
        solution.setCostValid(true);
    }

    private void updateGlobal(Solution solution) {
        if (!this.globalBestSolution.isPresent() || CollectionUtils.isBetterThan(solution, (Comparable)this.globalBestSolution.get())) {
            this.globalBestSolution = Optional.of(solution.makeCopy());
        }
    }

    public void initialize() {
        PopulationInitialization.apply(this.solutions, this.manager);
        this.evaluate();
    }

    public boolean isTerminated() {
        return this.currentGeneration >= this.manager.getMaxGeneration();
    }

    public void evolve() {
        TGPPopulationReplacementStrategy populationReplacement = this.manager.getReplacementStrategy();
        if (populationReplacement == TGPPopulationReplacementStrategy.MuPlusLambda) {
            this.muPlusLambdaEvolve();
        } else if (populationReplacement == TGPPopulationReplacementStrategy.TinyGP) {
            this.tinyGPEvolve();
        }
        ++this.currentGeneration;
    }

    private void muPlusLambdaEvolve() {
        Solution child;
        TupleTwo<Solution, Solution> tournament_winners;
        TournamentSelectionResult<Solution> tournament;
        int offspring_index;
        RandEngine randEngine = this.manager.getRandEngine();
        int iPopSize = this.manager.getPopulationSize();
        int elite_count = (int)(this.manager.getElitismRatio() * (double)iPopSize);
        int crossover_count = (int)(this.manager.getCrossoverRate() * (double)iPopSize);
        if (crossover_count % 2 != 0) {
            ++crossover_count;
        }
        int micro_mutation_count = (int)(this.manager.getMicroMutationRate() * (double)iPopSize);
        int macro_mutation_count = (int)(this.manager.getMacroMutationRate() * (double)iPopSize);
        int reproduction_count = iPopSize - crossover_count - micro_mutation_count - macro_mutation_count;
        ArrayList<Solution> offspring = new ArrayList<Solution>();
        this.bestSolutionInCurrentGeneration = null;
        for (offspring_index = 0; offspring_index < crossover_count; offspring_index += 2) {
            tournament = TournamentSelection.select(this.solutions, randEngine);
            tournament_winners = tournament.getWinners();
            Solution child1 = ((Solution)tournament_winners._1()).makeCopy();
            Solution child2 = ((Solution)tournament_winners._2()).makeCopy();
            Crossover.apply(child1, child2, this.manager);
            offspring.add(child1);
            offspring.add(child2);
        }
        for (offspring_index = 0; offspring_index < micro_mutation_count; ++offspring_index) {
            tournament = TournamentSelection.select(this.solutions, randEngine);
            tournament_winners = tournament.getWinners();
            child = ((Solution)tournament_winners._1()).makeCopy();
            MicroMutation.apply(child, this.manager);
            offspring.add(child);
        }
        for (offspring_index = 0; offspring_index < macro_mutation_count; ++offspring_index) {
            tournament = TournamentSelection.select(this.solutions, randEngine);
            tournament_winners = tournament.getWinners();
            child = ((Solution)tournament_winners._1()).makeCopy();
            MacroMutation.apply(child, this.manager);
            offspring.add(child);
        }
        for (offspring_index = 0; offspring_index < reproduction_count; ++offspring_index) {
            tournament = TournamentSelection.select(this.solutions, randEngine);
            tournament_winners = tournament.getWinners();
            child = ((Solution)tournament_winners._1()).makeCopy();
            offspring.add(child);
        }
        for (int i = 0; i < iPopSize; ++i) {
            Solution child2 = (Solution)offspring.get(i);
            this.evaluate(child2);
            if (this.bestSolutionInCurrentGeneration != null && !child2.isBetterThan(this.bestSolutionInCurrentGeneration)) continue;
            this.bestSolutionInCurrentGeneration = child2;
        }
        this.updateGlobal(this.bestSolutionInCurrentGeneration);
        QuickSort.sort(this.solutions, Solution::compareTo);
        QuickSort.sort(offspring, Solution::compareTo);
        for (offspring_index = elite_count; offspring_index < iPopSize; ++offspring_index) {
            this.solutions.set(offspring_index, (Solution)offspring.get(offspring_index - elite_count));
        }
    }

    private void tinyGPEvolve() {
        int iPopSize = this.manager.getPopulationSize();
        double sum_rate = this.manager.getCrossoverRate() + this.manager.getMacroMutationRate() + this.manager.getMicroMutationRate() + this.manager.getReproductionRate();
        double crossover_disk = this.manager.getCrossoverRate() / sum_rate;
        double micro_mutation_disk = (this.manager.getCrossoverRate() + this.manager.getMicroMutationRate()) / sum_rate;
        double macro_mutation_disk = (this.manager.getCrossoverRate() + this.manager.getMicroMutationRate() + this.manager.getMacroMutationRate()) / sum_rate;
        RandEngine randEngine = this.manager.getRandEngine();
        this.bestSolutionInCurrentGeneration = this.globalBestSolution.orElse(null);
        block0: for (int offspring_index = 0; offspring_index < iPopSize; ++offspring_index) {
            Solution child;
            double r = randEngine.uniform();
            ArrayList<Solution> children = new ArrayList<Solution>();
            ArrayList<Object> bad_parents = new ArrayList<Object>();
            TournamentSelectionResult<Solution> tournament = TournamentSelection.select(this.solutions, randEngine);
            TupleTwo<Solution, Solution> tournament_winners = tournament.getWinners();
            TupleTwo<Solution, Solution> tournament_losers = tournament.getLosers();
            bad_parents.add(tournament_losers._1());
            bad_parents.add(tournament_losers._2());
            if (r <= crossover_disk) {
                Solution child1 = ((Solution)tournament_winners._1()).makeCopy();
                Solution child2 = ((Solution)tournament_winners._2()).makeCopy();
                Crossover.apply(child1, child2, this.manager);
                children.add(child1);
                children.add(child2);
            } else if (r <= micro_mutation_disk) {
                child = ((Solution)tournament_winners._1()).makeCopy();
                MicroMutation.apply(child, this.manager);
                children.add(child);
            } else if (r <= macro_mutation_disk) {
                child = ((Solution)tournament_winners._1()).makeCopy();
                MacroMutation.apply(child, this.manager);
                children.add(child);
            } else {
                child = ((Solution)tournament_winners._1()).makeCopy();
                children.add(child);
            }
            boolean successfully_replaced = false;
            for (int i = 0; i < children.size(); ++i) {
                Solution child2 = (Solution)children.get(i);
                this.evaluate(child2);
                if (this.bestSolutionInCurrentGeneration == null || child2.isBetterThan(this.bestSolutionInCurrentGeneration)) {
                    this.bestSolutionInCurrentGeneration = child2;
                }
                for (Solution solution : bad_parents) {
                    if (!child2.isBetterThan(solution)) continue;
                    successfully_replaced = true;
                    this.solutions.set(this.solutions.indexOf(solution), child2);
                    break;
                }
                if (successfully_replaced) continue block0;
            }
        }
        this.updateGlobal(this.bestSolutionInCurrentGeneration);
    }

    public Solution getGlobalBestSolution() {
        return this.globalBestSolution.get();
    }

    public double getCostInCurrentGeneration() {
        return this.bestSolutionInCurrentGeneration.getCost();
    }

    public int size() {
        return this.solutions.size();
    }

    public List<Solution> getSolutions() {
        return this.solutions;
    }

    public TreeGP getManager() {
        return this.manager;
    }

    public Solution getBestSolutionInCurrentGeneration() {
        return this.bestSolutionInCurrentGeneration;
    }

    public int getCurrentGeneration() {
        return this.currentGeneration;
    }

    public void setBestSolutionInCurrentGeneration(Solution bestSolutionInCurrentGeneration) {
        this.bestSolutionInCurrentGeneration = bestSolutionInCurrentGeneration;
    }

    public void setCurrentGeneration(int currentGeneration) {
        this.currentGeneration = currentGeneration;
    }
}

