/*
 * Decompiled with CFR 0.152.
 */
package com.github.chen0040.gp.treegp.program;

import com.github.chen0040.gp.commons.Observation;
import com.github.chen0040.gp.exceptions.InvalidCostException;
import com.github.chen0040.gp.treegp.program.Program;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;

public class Solution
implements Comparable<Solution>,
Serializable {
    private static final long serialVersionUID = 5589700036065720457L;
    private double cost;
    private boolean costValid;
    private final List<Program> trees = new ArrayList<Program>();

    public Solution() {
    }

    public Solution(int treeCount, Function<Integer, Program> generator) {
        for (int i = 0; i < treeCount; ++i) {
            this.trees.add(generator.apply(i));
        }
    }

    public Solution makeCopy() {
        Solution clone = new Solution();
        clone.copy(this);
        return clone;
    }

    public void copy(Solution that) {
        this.trees.clear();
        for (int i = 0; i < that.trees.size(); ++i) {
            this.trees.add(that.trees.get(i).makeCopy());
        }
        this.cost = that.cost;
        this.costValid = that.costValid;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.trees.size(); ++i) {
            if (i != 0) {
                sb.append("\n");
            }
            sb.append("Trees[").append(i).append("]: ").append(this.trees.get(i));
        }
        return sb.toString();
    }

    public String mathExpression() {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.trees.size(); ++i) {
            if (i != 0) {
                sb.append("\n");
            }
            sb.append("Trees[").append(i).append("]: ").append(this.trees.get(i).mathExpression());
        }
        return sb.toString();
    }

    public void invalidateCost() {
        this.costValid = false;
    }

    public void execute(Observation observation) {
        for (int i = 0; i < this.trees.size(); ++i) {
            Program tree = this.trees.get(i);
            tree.read(observation);
            double output = tree.execute(new Object[0]);
            observation.setPredictedOutput(i % observation.outputCount(), output);
        }
    }

    public int averageTreeDepth() {
        if (this.trees.isEmpty()) {
            return 0;
        }
        int sum = 0;
        for (int i = 0; i < this.trees.size(); ++i) {
            sum += this.trees.get(i).getDepth();
        }
        return sum / this.trees.size();
    }

    public int averageTreeLength() {
        if (this.trees.isEmpty()) {
            return 0;
        }
        int sum = 0;
        for (int i = 0; i < this.trees.size(); ++i) {
            sum += this.trees.get(i).getLength();
        }
        return sum / this.trees.size();
    }

    @Override
    public int compareTo(Solution that) {
        if (!this.costValid || !that.costValid) {
            throw new InvalidCostException("cost of the solutions involved in the comparison is not valid for comparison");
        }
        int cmp = Double.compare(this.cost, that.cost);
        if (cmp == 0) {
            int this_better_count = 0;
            for (int i = 0; i < this.trees.size(); ++i) {
                if (this.trees.get(i).compareTo(that.trees.get(i)) >= 0) continue;
                ++this_better_count;
            }
            return Integer.compare(this.trees.size(), this_better_count * 2);
        }
        return cmp;
    }

    public boolean isBetterThan(Solution that) {
        return this.compareTo(that) < 0;
    }

    public double getCost() {
        return this.cost;
    }

    public boolean isCostValid() {
        return this.costValid;
    }

    public List<Program> getTrees() {
        return this.trees;
    }

    public void setCost(double cost) {
        this.cost = cost;
    }

    public void setCostValid(boolean costValid) {
        this.costValid = costValid;
    }
}

