/*
 * Decompiled with CFR 0.152.
 */
package com.github.chen0040.gp.utils;

import com.github.chen0040.data.utils.TupleTwo;
import com.github.chen0040.gp.services.RandEngine;
import com.github.chen0040.gp.services.SimpleRandEngine;
import java.util.ArrayList;
import java.util.List;

public class CollectionUtils {
    public static <T> void shuffle(List<T> a, RandEngine randEngine) {
        for (int i = 0; i < a.size(); ++i) {
            int j = randEngine.nextInt(i + 1);
            CollectionUtils.exchange(a, i, j);
        }
    }

    public static <T> void shuffle(List<T> a) {
        SimpleRandEngine randEngine = new SimpleRandEngine();
        CollectionUtils.shuffle(a, randEngine);
    }

    public static <T> void exchange(List<T> a, int i, int j) {
        T temp = a.get(i);
        a.set(i, a.get(j));
        a.set(j, temp);
    }

    public static <T extends Comparable<T>> boolean isBetterThan(T a, T b) {
        return a.compareTo(b) < 0;
    }

    public static <T> TupleTwo<List<T>, List<T>> split(List<T> data, double p) {
        int i;
        int split_index = (int)((double)data.size() * p);
        ArrayList<T> data1 = new ArrayList<T>();
        ArrayList<T> data2 = new ArrayList<T>();
        for (i = 0; i < split_index; ++i) {
            data1.add(data.get(i));
        }
        for (i = split_index; i < data.size(); ++i) {
            data2.add(data.get(i));
        }
        return new TupleTwo(data1, data2);
    }
}

