/*
 * Decompiled with CFR 0.152.
 */
package com.github.chen0040.svmext.oneclass;

import com.github.chen0040.data.frame.DataFrame;
import com.github.chen0040.data.frame.DataRow;
import com.github.chen0040.libsvm.SupportVectorMachine;
import com.github.chen0040.libsvm.SupportVectorMachineNode;
import com.github.chen0040.libsvm.svm_model;
import com.github.chen0040.libsvm.svm_parameter;
import com.github.chen0040.libsvm.svm_print_interface;
import com.github.chen0040.libsvm.svm_problem;
import com.github.chen0040.svmext.Learner;
import java.util.Vector;
import java.util.function.Supplier;

public class OneClassSVM
implements Learner {
    private static svm_print_interface svm_print_null = new svm_print_interface(){

        @Override
        public void print(String s) {
        }
    };
    private svm_parameter param;
    private int cross_validation;
    private svm_model model;
    private boolean quiet;
    public Supplier<Double> thresholdSupplier;

    public void copy(OneClassSVM that) {
        this.param = that.param == null ? null : that.param.makeCopy();
        this.cross_validation = that.cross_validation;
        this.quiet = that.quiet;
        svm_model svm_model2 = this.model = that.model == null ? null : that.model.makeCopy();
        if (this.model != null) {
            this.model.param = this.param;
        }
    }

    private double threshold() {
        if (this.thresholdSupplier == null) {
            return 0.0;
        }
        return this.thresholdSupplier.get();
    }

    public OneClassSVM makeCopy() {
        OneClassSVM clone = new OneClassSVM();
        clone.copy(this);
        return clone;
    }

    public OneClassSVM() {
        Object print_func = null;
        this.param = new svm_parameter();
        this.param.svm_type = 2;
        this.param.kernel_type = 2;
        this.param.degree = 3;
        this.param.gamma = 0.0;
        this.param.coef0 = 0.0;
        this.param.nu = 0.5;
        this.param.cache_size = 100.0;
        this.param.C = 1.0;
        this.param.eps = 0.001;
        this.param.p = 0.1;
        this.param.shrinking = 1;
        this.param.probability = 0;
        this.param.nr_weight = 0;
        this.param.weight_label = new int[0];
        this.param.weight = new double[0];
        this.cross_validation = 0;
        SupportVectorMachine.svm_set_print_string_function(svm_print_null);
        this.quiet = true;
    }

    public void set_nu(double nu) {
        this.param.nu = nu;
    }

    public void set_gamma(double gamma) {
        this.param.gamma = gamma;
    }

    public boolean isQuiet() {
        return this.quiet;
    }

    public void setQuiet(boolean quiet) {
        this.quiet = quiet;
    }

    public svm_parameter getParameters() {
        return this.param;
    }

    @Override
    public double transform(DataRow row) {
        double[] x0 = row.toArray();
        int n = x0.length;
        SupportVectorMachineNode[] x = new SupportVectorMachineNode[n];
        for (int j = 0; j < n; ++j) {
            x[j] = new SupportVectorMachineNode();
            x[j].index = j + 1;
            x[j].value = x0[j];
        }
        double v = SupportVectorMachine.svm_predict(this.model, x);
        return v;
    }

    public boolean isAnomaly(DataRow tuple) {
        double p = this.transform(tuple);
        return p < this.threshold();
    }

    @Override
    public void fit(DataFrame dataFrame) {
        int i;
        if (this.quiet) {
            SupportVectorMachine.svm_set_print_string_function(svm_print_null);
        } else {
            SupportVectorMachine.svm_set_print_string_function(null);
        }
        Vector<SupportVectorMachineNode[]> vx = new Vector<SupportVectorMachineNode[]>();
        int max_index = 0;
        int m = dataFrame.rowCount();
        for (int i2 = 0; i2 < m; ++i2) {
            DataRow tuple = dataFrame.row(i2);
            double[] x0 = tuple.toArray();
            int n = x0.length;
            SupportVectorMachineNode[] x = new SupportVectorMachineNode[n];
            for (int j = 0; j < n; ++j) {
                x[j] = new SupportVectorMachineNode();
                x[j].index = j + 1;
                x[j].value = x0[j];
            }
            if (n > 0) {
                max_index = Math.max(max_index, x[n - 1].index);
            }
            vx.addElement(x);
        }
        svm_problem prob = new svm_problem();
        prob.l = m;
        prob.x = new SupportVectorMachineNode[m][];
        for (i = 0; i < prob.l; ++i) {
            prob.x[i] = (SupportVectorMachineNode[])vx.elementAt(i);
        }
        prob.y = new double[m];
        for (i = 0; i < prob.l; ++i) {
            prob.y[i] = 0.0;
        }
        if (this.param.gamma == 0.0 && max_index > 0) {
            this.param.gamma = 1.0 / (double)max_index;
        }
        this.model = SupportVectorMachine.svm_train(prob, this.param);
    }
}

