/*
 * Decompiled with CFR 0.152.
 */
package com.github.chen0040.svmext.regression;

import com.github.chen0040.data.frame.DataFrame;
import com.github.chen0040.data.frame.DataRow;
import com.github.chen0040.data.utils.Scaler;
import com.github.chen0040.libsvm.SupportVectorMachine;
import com.github.chen0040.libsvm.SupportVectorMachineNode;
import com.github.chen0040.libsvm.svm_model;
import com.github.chen0040.libsvm.svm_parameter;
import com.github.chen0040.libsvm.svm_print_interface;
import com.github.chen0040.libsvm.svm_problem;
import com.github.chen0040.svmext.Learner;
import java.util.Vector;

public class SVR
implements Learner {
    private static svm_print_interface svm_print_null = new svm_print_interface(){

        @Override
        public void print(String s) {
        }
    };
    private svm_parameter param;
    private int cross_validation;
    private svm_model model;
    private boolean quiet;
    private final Scaler scaler = new Scaler();
    private String name;

    public void copy(SVR that) {
        this.param = that.param == null ? null : that.param.makeCopy();
        this.cross_validation = that.cross_validation;
        svm_model svm_model2 = this.model = that.model == null ? null : that.model.makeCopy();
        if (this.model != null) {
            this.model.param = this.param;
        }
        this.quiet = that.quiet;
        this.scaler.copy(that.scaler);
    }

    public SVR makeCopy() {
        SVR clone = new SVR();
        clone.copy(this);
        return clone;
    }

    public SVR() {
        Object print_func = null;
        this.param = new svm_parameter();
        this.param.svm_type = 4;
        this.param.kernel_type = 2;
        this.param.degree = 3;
        this.param.gamma = 0.0;
        this.param.coef0 = 0.0;
        this.param.nu = 0.5;
        this.param.cache_size = 100.0;
        this.param.C = 1.0;
        this.param.eps = 0.001;
        this.param.p = 0.1;
        this.param.shrinking = 1;
        this.param.probability = 0;
        this.param.nr_weight = 0;
        this.param.weight_label = new int[0];
        this.param.weight = new double[0];
        this.cross_validation = 0;
        SupportVectorMachine.svm_set_print_string_function(svm_print_null);
        this.quiet = true;
    }

    public SVMType getSVMType() {
        if (this.param.svm_type == 3) {
            return SVMType.epsilon;
        }
        return SVMType.nu;
    }

    public void setSVMType(SVMType type) {
        switch (type) {
            case nu: {
                this.param.svm_type = 4;
                break;
            }
            case epsilon: {
                this.param.svm_type = 3;
            }
        }
    }

    public boolean isQuiet() {
        return this.quiet;
    }

    public void setQuiet(boolean quiet) {
        this.quiet = quiet;
    }

    public svm_parameter getParameters() {
        return this.param;
    }

    @Override
    public double transform(DataRow row) {
        row = this.scaler.transform(row);
        double[] x0 = row.toArray();
        int n = x0.length;
        SupportVectorMachineNode[] x = new SupportVectorMachineNode[n];
        for (int j = 0; j < n; ++j) {
            x[j] = new SupportVectorMachineNode();
            x[j].index = j + 1;
            x[j].value = x0[j];
        }
        double v = SupportVectorMachine.svm_predict(this.model, x);
        return this.scaler.inverseTransform(row.targetColumnName(), v);
    }

    @Override
    public void fit(DataFrame frame) {
        int i;
        if (this.quiet) {
            SupportVectorMachine.svm_set_print_string_function(svm_print_null);
        } else {
            SupportVectorMachine.svm_set_print_string_function(null);
        }
        Vector<Double> vy = new Vector<Double>();
        Vector<SupportVectorMachineNode[]> vx = new Vector<SupportVectorMachineNode[]>();
        int max_index = 0;
        this.scaler.fit(frame);
        int m = frame.rowCount();
        for (int i2 = 0; i2 < m; ++i2) {
            DataRow row = frame.row(i2);
            row = this.scaler.transform(row);
            double[] x0 = row.toArray();
            int n = x0.length;
            vy.add(row.target());
            SupportVectorMachineNode[] x = new SupportVectorMachineNode[n];
            for (int j = 0; j < n; ++j) {
                x[j] = new SupportVectorMachineNode();
                x[j].index = j + 1;
                x[j].value = x0[j];
            }
            if (n > 0) {
                max_index = Math.max(max_index, x[n - 1].index);
            }
            vx.addElement(x);
        }
        svm_problem prob = new svm_problem();
        prob.l = m;
        prob.x = new SupportVectorMachineNode[prob.l][];
        for (i = 0; i < prob.l; ++i) {
            prob.x[i] = (SupportVectorMachineNode[])vx.elementAt(i);
        }
        prob.y = new double[prob.l];
        for (i = 0; i < prob.l; ++i) {
            prob.y[i] = (Double)vy.elementAt(i);
        }
        if (this.param.gamma == 0.0 && max_index > 0) {
            this.param.gamma = 1.0 / (double)max_index;
        }
        this.model = SupportVectorMachine.svm_train(prob, this.param);
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public static enum SVMType {
        nu,
        epsilon;

    }
}

