/*
 * Decompiled with CFR 0.152.
 */
package com.github.chen0040.libsvm;

import com.github.chen0040.libsvm.SupportVectorMachine;
import com.github.chen0040.libsvm.SupportVectorMachineNode;
import com.github.chen0040.libsvm.svm_model;
import com.github.chen0040.libsvm.svm_print_interface;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.StringTokenizer;

class svm_predict {
    private static svm_print_interface svm_print_null = new svm_print_interface(){

        @Override
        public void print(String s) {
        }
    };
    private static svm_print_interface svm_print_stdout;
    private static svm_print_interface svm_print_string;

    svm_predict() {
    }

    static void info(String s) {
        svm_print_string.print(s);
    }

    private static double atof(String s) {
        return Double.valueOf(s);
    }

    private static int atoi(String s) {
        return Integer.parseInt(s);
    }

    private static void predict(BufferedReader input, DataOutputStream output, svm_model model, int predict_probability) throws IOException {
        String line;
        int correct = 0;
        int total = 0;
        double error = 0.0;
        double sumv = 0.0;
        double sumy = 0.0;
        double sumvv = 0.0;
        double sumyy = 0.0;
        double sumvy = 0.0;
        int svm_type = SupportVectorMachine.svm_get_svm_type(model);
        int nr_class = SupportVectorMachine.svm_get_nr_class(model);
        double[] prob_estimates = null;
        if (predict_probability == 1) {
            if (svm_type == 3 || svm_type == 4) {
                svm_predict.info("Prob. model for test data: target value = predicted value + z,\nz: Laplace distribution e^(-|z|/sigma)/(2sigma),sigma=" + SupportVectorMachine.svm_get_svr_probability(model) + "\n");
            } else {
                int[] labels = new int[nr_class];
                SupportVectorMachine.svm_get_labels(model, labels);
                prob_estimates = new double[nr_class];
                output.writeBytes("labels");
                for (int j = 0; j < nr_class; ++j) {
                    output.writeBytes(" " + labels[j]);
                }
                output.writeBytes("\n");
            }
        }
        while ((line = input.readLine()) != null) {
            double v;
            StringTokenizer st = new StringTokenizer(line, " \t\n\r\f:");
            double target = svm_predict.atof(st.nextToken());
            int m = st.countTokens() / 2;
            SupportVectorMachineNode[] x = new SupportVectorMachineNode[m];
            for (int j = 0; j < m; ++j) {
                x[j] = new SupportVectorMachineNode();
                x[j].index = svm_predict.atoi(st.nextToken());
                x[j].value = svm_predict.atof(st.nextToken());
            }
            if (predict_probability == 1 && (svm_type == 0 || svm_type == 1)) {
                v = SupportVectorMachine.svm_predict_probability(model, x, prob_estimates);
                output.writeBytes(v + " ");
                for (int j = 0; j < nr_class; ++j) {
                    output.writeBytes(prob_estimates[j] + " ");
                }
                output.writeBytes("\n");
            } else {
                v = SupportVectorMachine.svm_predict(model, x);
                output.writeBytes(v + "\n");
            }
            if (v == target) {
                ++correct;
            }
            error += (v - target) * (v - target);
            sumv += v;
            sumy += target;
            sumvv += v * v;
            sumyy += target * target;
            sumvy += v * target;
            ++total;
        }
        if (svm_type == 3 || svm_type == 4) {
            svm_predict.info("Mean squared error = " + error / (double)total + " (regression)\n");
            svm_predict.info("Squared correlation coefficient = " + ((double)total * sumvy - sumv * sumy) * ((double)total * sumvy - sumv * sumy) / (((double)total * sumvv - sumv * sumv) * ((double)total * sumyy - sumy * sumy)) + " (regression)\n");
        } else {
            svm_predict.info("Accuracy = " + (double)correct / (double)total * 100.0 + "% (" + correct + "/" + total + ") (classification)\n");
        }
    }

    private static void exit_with_help() {
        System.err.print("usage: svm_predict [options] test_file model_file output_file\noptions:\n-b probability_estimates: whether to predict probability estimates, 0 or 1 (default 0); one-class SVM not supported yet\n-q : quiet mode (no outputs)\n");
        System.exit(1);
    }

    public static void main(String[] argv) throws IOException {
        int i;
        int predict_probability = 0;
        svm_print_string = svm_print_stdout;
        block7: for (i = 0; i < argv.length && argv[i].charAt(0) == '-'; ++i) {
            switch (argv[++i - 1].charAt(1)) {
                case 'b': {
                    predict_probability = svm_predict.atoi(argv[i]);
                    continue block7;
                }
                case 'q': {
                    svm_print_string = svm_print_null;
                    --i;
                    continue block7;
                }
                default: {
                    System.err.print("Unknown option: " + argv[i - 1] + "\n");
                    svm_predict.exit_with_help();
                }
            }
        }
        if (i >= argv.length - 2) {
            svm_predict.exit_with_help();
        }
        try {
            BufferedReader input = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(argv[i]), "UTF-8"));
            DataOutputStream output = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(argv[i + 2])));
            svm_model model = SupportVectorMachine.svm_load_model(argv[i + 1]);
            if (model == null) {
                System.err.print("can't open model file " + argv[i + 1] + "\n");
                System.exit(1);
            }
            if (predict_probability == 1) {
                if (SupportVectorMachine.svm_check_probability_model(model) == 0) {
                    System.err.print("Model does not support probabiliy estimates\n");
                    System.exit(1);
                }
            } else if (SupportVectorMachine.svm_check_probability_model(model) != 0) {
                svm_predict.info("Model supports probability estimates, but disabled in prediction.\n");
            }
            svm_predict.predict(input, output, model, predict_probability);
            input.close();
            output.close();
        }
        catch (FileNotFoundException e) {
            svm_predict.exit_with_help();
        }
        catch (ArrayIndexOutOfBoundsException e) {
            svm_predict.exit_with_help();
        }
    }

    static {
        svm_print_string = svm_print_stdout = new svm_print_interface(){

            @Override
            public void print(String s) {
                System.out.print(s);
            }
        };
    }
}

