/*
 * Decompiled with CFR 0.152.
 */
package com.github.chen0040.svmext.classifiers;

import com.github.chen0040.data.frame.DataFrame;
import com.github.chen0040.data.frame.DataRow;
import com.github.chen0040.libsvm.SupportVectorMachine;
import com.github.chen0040.libsvm.SupportVectorMachineNode;
import com.github.chen0040.libsvm.svm_model;
import com.github.chen0040.libsvm.svm_parameter;
import com.github.chen0040.libsvm.svm_print_interface;
import com.github.chen0040.libsvm.svm_problem;
import com.github.chen0040.svmext.Learner;
import java.util.Vector;

public class BinarySVC
implements Learner {
    private static svm_print_interface svm_print_null = new svm_print_interface(){

        @Override
        public void print(String s) {
        }
    };
    private svm_parameter parameters;
    private int cross_validation;
    private svm_model model;
    private boolean quiet;

    public void copy(BinarySVC that) {
        this.parameters = that.parameters == null ? null : that.parameters.makeCopy();
        this.cross_validation = that.cross_validation;
        this.model = that.model == null ? null : that.model.makeCopy();
        this.quiet = that.quiet;
    }

    public BinarySVC makeCopy() {
        BinarySVC clone = new BinarySVC();
        clone.copy(this);
        return clone;
    }

    public BinarySVC() {
        this.init();
    }

    public static svm_print_interface getSvm_print_null() {
        return svm_print_null;
    }

    public static void setSvm_print_null(svm_print_interface svm_print_null) {
        BinarySVC.svm_print_null = svm_print_null;
    }

    public int getCross_validation() {
        return this.cross_validation;
    }

    public void setCross_validation(int cross_validation) {
        this.cross_validation = cross_validation;
    }

    public svm_model getModel() {
        return this.model;
    }

    public void setModel(svm_model model) {
        this.model = model;
    }

    public boolean isQuiet() {
        return this.quiet;
    }

    public void setQuiet(boolean quiet) {
        this.quiet = quiet;
    }

    public SVMType getSVMType() {
        if (this.parameters.svm_type == 0) {
            return SVMType.C;
        }
        return SVMType.nu;
    }

    public void setSVMType(SVMType type) {
        switch (type) {
            case C: {
                this.parameters.svm_type = 0;
                break;
            }
            case nu: {
                this.parameters.svm_type = 1;
            }
        }
    }

    private void init() {
        Object print_func = null;
        this.parameters = new svm_parameter();
        this.parameters.svm_type = 0;
        this.parameters.kernel_type = 2;
        this.parameters.degree = 3;
        this.parameters.gamma = 0.0;
        this.parameters.coef0 = 0.0;
        this.parameters.nu = 0.5;
        this.parameters.cache_size = 100.0;
        this.parameters.C = 1.0;
        this.parameters.eps = 0.001;
        this.parameters.p = 0.1;
        this.parameters.shrinking = 1;
        this.parameters.probability = 0;
        this.parameters.nr_weight = 0;
        this.parameters.weight_label = new int[0];
        this.parameters.weight = new double[0];
        this.cross_validation = 0;
        SupportVectorMachine.svm_set_print_string_function(null);
        this.quiet = false;
    }

    public svm_parameter getParameters() {
        return this.parameters;
    }

    public void setParameters(svm_parameter parameters) {
        this.parameters = parameters;
    }

    private void info(String info) {
    }

    @Override
    public double transform(DataRow row) {
        double[] x0 = row.toArray();
        int n = x0.length;
        SupportVectorMachineNode[] x = new SupportVectorMachineNode[n];
        for (int j = 0; j < n; ++j) {
            x[j] = new SupportVectorMachineNode();
            x[j].index = j + 1;
            x[j].value = x0[j];
        }
        return SupportVectorMachine.svm_predict(this.model, x);
    }

    public boolean isInClass(DataRow row) {
        double p = this.transform(row);
        return p > 0.0;
    }

    @Override
    public void fit(DataFrame dataFrame) {
        int i;
        if (this.quiet) {
            SupportVectorMachine.svm_set_print_string_function(svm_print_null);
        } else {
            SupportVectorMachine.svm_set_print_string_function(null);
        }
        Vector<Double> vy = new Vector<Double>();
        Vector<SupportVectorMachineNode[]> vx = new Vector<SupportVectorMachineNode[]>();
        int max_index = 0;
        int m = dataFrame.rowCount();
        for (int i2 = 0; i2 < m; ++i2) {
            DataRow row = dataFrame.row(i2);
            double[] x0 = row.toArray();
            int n = x0.length;
            vy.add(row.target() > 0.5 ? 1.0 : -1.0);
            SupportVectorMachineNode[] x = new SupportVectorMachineNode[n];
            for (int j = 0; j < n; ++j) {
                x[j] = new SupportVectorMachineNode();
                x[j].index = j + 1;
                x[j].value = x0[j];
            }
            if (n > 0) {
                max_index = Math.max(max_index, x[n - 1].index);
            }
            vx.addElement(x);
        }
        svm_problem prob = new svm_problem();
        prob.l = m;
        prob.x = new SupportVectorMachineNode[m][];
        for (i = 0; i < m; ++i) {
            prob.x[i] = (SupportVectorMachineNode[])vx.elementAt(i);
        }
        prob.y = new double[m];
        for (i = 0; i < m; ++i) {
            prob.y[i] = (Double)vy.elementAt(i);
        }
        if (this.parameters.gamma == 0.0 && max_index > 0) {
            this.parameters.gamma = 1.0 / (double)max_index;
        }
        this.model = SupportVectorMachine.svm_train(prob, this.parameters);
    }

    public static enum SVMType {
        C,
        nu;

    }
}

