/*
 * Decompiled with CFR 0.152.
 */
package com.github.jpstarter;

import com.github.jpstarter.utils.HttpClient;
import com.github.jpstarter.utils.NetUtils;
import io.prometheus.client.CollectorRegistry;
import io.prometheus.client.exporter.HTTPServer;
import io.prometheus.client.hotspot.DefaultExports;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.util.HashMap;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PrometheusLoader {
    private static Logger logger = LoggerFactory.getLogger(PrometheusLoader.class);
    private final String FILE_NAME = "java-prometheus-starter.properties";
    private final String HOST;
    private final int PORT;
    private final String APP_NAME;
    private final String PROMETHEUS_REGISTER_URL;

    public PrometheusLoader() throws IOException {
        InputStream in = this.getClass().getClassLoader().getResourceAsStream("java-prometheus-starter.properties");
        if (null == in) {
            throw new FileNotFoundException("classpath not foundjava-prometheus-starter.properties");
        }
        Properties properties = new Properties();
        properties.load(in);
        String port = properties.getProperty("port");
        this.PORT = null == port || "".equals(port) ? 1234 : Integer.parseInt(port);
        this.APP_NAME = properties.getProperty("app.name");
        if (null == this.APP_NAME || "".equals(this.APP_NAME)) {
            throw new IllegalArgumentException("app.name is empty");
        }
        this.PROMETHEUS_REGISTER_URL = properties.getProperty("reload.register.url");
        if (null == this.PROMETHEUS_REGISTER_URL || "".equals(this.PROMETHEUS_REGISTER_URL)) {
            throw new IllegalArgumentException("reload.register.url is empty");
        }
        this.HOST = NetUtils.getLocalHost();
        this.register("http://" + this.PROMETHEUS_REGISTER_URL + "/register");
    }

    private void register(String registerURL) throws IOException {
        HashMap<String, String> requestParams = new HashMap<String, String>();
        requestParams.put("appName", this.APP_NAME);
        requestParams.put("host", this.HOST);
        requestParams.put("port", String.valueOf(this.PORT));
        String resp = HttpClient.doPost(registerURL, requestParams);
        logger.info("register resp:{}", (Object)resp);
    }

    public void start() throws IOException {
        InetSocketAddress addr = new InetSocketAddress(this.HOST, this.PORT);
        final HTTPServer httpServer = new HTTPServer(addr, CollectorRegistry.defaultRegistry, true);
        Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(){

            @Override
            public void run() {
                httpServer.stop();
                logger.info("PrometheusLoader stop complete ...");
            }
        }));
        DefaultExports.initialize();
        logger.info("PrometheusLoader started complete ...");
    }

    public static void initialize() {
        try {
            new PrometheusLoader().start();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

