/*
 * Decompiled with CFR 0.152.
 */
package com.github.jratelimit.commons.utils;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.springframework.util.ResourceUtils;

public class PropsRead<K, V> {
    private String url;
    private Properties properties = new Properties();
    private Map<K, V> map = new HashMap();

    public PropsRead(String url) throws IOException {
        this.url = url;
        this.read();
    }

    private void read() throws IOException {
        File file = ResourceUtils.getFile((String)("classpath:" + this.url));
        if (!file.exists()) {
            throw new FileNotFoundException("classpath not found" + this.url);
        }
        InputStream in = this.getClass().getClassLoader().getResourceAsStream(this.url);
        this.properties.load(in);
    }

    public void parseMapIntValue() {
        Enumeration<?> en = this.properties.propertyNames();
        while (en.hasMoreElements()) {
            String key = (String)en.nextElement();
            Integer value = Integer.parseInt(this.properties.getProperty(key));
            this.map.put(key, value);
        }
    }

    public void parseMapStringValue() {
        Enumeration<?> en = this.properties.propertyNames();
        while (en.hasMoreElements()) {
            String key = (String)en.nextElement();
            String value = this.properties.getProperty(key);
            this.map.put(key, value);
        }
    }

    public Properties getProperties() {
        return this.properties;
    }

    public Map<K, V> getMap() {
        return this.map;
    }
}

