/*
 * Decompiled with CFR 0.152.
 */
package com.github.jratelimit.support;

import com.github.jratelimit.annotation.RateLimit;
import com.github.jratelimit.support.ServiceRateLimitConfig;
import com.github.jratelimit.support.ServiceRateLimitCounter;
import java.io.IOException;
import java.lang.reflect.Method;
import org.apache.commons.lang3.ArrayUtils;
import org.springframework.context.ResourceLoaderAware;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.core.io.support.ResourcePatternResolver;
import org.springframework.core.io.support.ResourcePatternUtils;
import org.springframework.core.type.classreading.CachingMetadataReaderFactory;
import org.springframework.core.type.classreading.MetadataReader;
import org.springframework.core.type.classreading.MetadataReaderFactory;
import org.springframework.util.ClassUtils;
import org.springframework.util.SystemPropertyUtils;

public class ServiceRateLimitScanner
implements ResourceLoaderAware {
    private ResourcePatternResolver resourcePatternResolver = new PathMatchingResourcePatternResolver();
    private MetadataReaderFactory metadataReaderFactory = new CachingMetadataReaderFactory((ResourceLoader)this.resourcePatternResolver);

    public void setResourceLoader(ResourceLoader resourceLoader) {
        this.resourcePatternResolver = ResourcePatternUtils.getResourcePatternResolver((ResourceLoader)resourceLoader);
        this.metadataReaderFactory = new CachingMetadataReaderFactory(resourceLoader);
    }

    public void doScan(String scanPackage) {
        String scanPackagePath = "classpath*:" + ClassUtils.convertClassNameToResourcePath((String)SystemPropertyUtils.resolvePlaceholders((String)scanPackage)) + "/**/*.class";
        Resource[] resources = new Resource[]{};
        try {
            resources = this.resourcePatternResolver.getResources(scanPackagePath);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        for (int i = 0; i < resources.length; ++i) {
            Resource resource = resources[i];
            if (!resource.isReadable()) continue;
            MetadataReader metadataReader = null;
            try {
                metadataReader = this.metadataReaderFactory.getMetadataReader(resource);
                Class<?> classz = Class.forName(metadataReader.getClassMetadata().getClassName());
                Object[] methods = classz.getMethods();
                if (ArrayUtils.isEmpty((Object[])methods)) continue;
                for (Object method : methods) {
                    RateLimit annotation = ((Method)method).getAnnotation(RateLimit.class);
                    if (null == annotation) continue;
                    String methodName = ServiceRateLimitConfig.getMode() != false ? classz.getName() + "." + ((Method)method).getName() : ((Method)method).getName();
                    ServiceRateLimitCounter.addCounter(methodName);
                }
                continue;
            }
            catch (IOException e) {
                e.printStackTrace();
                continue;
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
        }
    }
}

