/*
 * Decompiled with CFR 0.152.
 */
package com.github.jratelimit.support;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.collections4.MapUtils;

public class ServiceRateLimitCounter {
    private static ConcurrentMap<String, AtomicLong> counterStorage = new ConcurrentHashMap<String, AtomicLong>();

    protected static void addCounter(String methodName) {
        counterStorage.put(methodName, new AtomicLong(0L));
    }

    public static long incrementAndGet(String methodName) {
        AtomicLong counter = (AtomicLong)counterStorage.get(methodName);
        if (null != counter) {
            return counter.incrementAndGet();
        }
        return 0L;
    }

    public static long getRate(String methodName) {
        AtomicLong counter = (AtomicLong)counterStorage.get(methodName);
        if (null != counter) {
            return counter.get();
        }
        return 0L;
    }

    public static void clearCounter() {
        if (MapUtils.isNotEmpty(counterStorage)) {
            for (Map.Entry entry : counterStorage.entrySet()) {
                ((AtomicLong)entry.getValue()).set(0L);
            }
        }
    }
}

