/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.autoconfig.commonconfig.config;

import com.alibaba.fastjson.serializer.SerializerFeature;
import com.alibaba.fastjson.support.config.FastJsonConfig;
import com.alibaba.fastjson.support.spring.FastJsonHttpMessageConverter;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.interceptor.LoginInterceptor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.MediaType;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.ViewControllerRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurerAdapter;

@Configuration
public class WebConfig {
    @Autowired
    private LoginInterceptor loginInterceptor;

    @Bean
    public WebMvcConfigurerAdapter webMvcConfigurerAdapter() {
        WebMvcConfigurerAdapter webMvcConfigurerAdapter = new WebMvcConfigurerAdapter(){

            public void addViewControllers(ViewControllerRegistry registry) {
                registry.addViewController("/").setViewName("login");
                registry.addViewController("/admin").setViewName("adminLogin");
            }

            public void addInterceptors(InterceptorRegistry registry) {
                registry.addInterceptor((HandlerInterceptor)WebConfig.this.loginInterceptor).addPathPatterns(new String[]{"/main/**"}).excludePathPatterns(new String[]{"/main/subaccount/adminLogin", "/main/subaccount/login"});
            }

            public void configureMessageConverters(List<HttpMessageConverter<?>> converters) {
                super.configureMessageConverters(converters);
                FastJsonHttpMessageConverter fastConverter = new FastJsonHttpMessageConverter();
                FastJsonConfig fastJsonConfig = new FastJsonConfig();
                fastJsonConfig.setSerializerFeatures(new SerializerFeature[]{SerializerFeature.PrettyFormat});
                ArrayList<MediaType> fastMediaTypes = new ArrayList<MediaType>();
                fastMediaTypes.add(MediaType.APPLICATION_JSON_UTF8);
                fastConverter.setSupportedMediaTypes(fastMediaTypes);
                fastConverter.setFastJsonConfig(fastJsonConfig);
                converters.add((HttpMessageConverter<?>)fastConverter);
            }
        };
        return webMvcConfigurerAdapter;
    }
}

