/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.autoconfig.commonconfig.config.datasource;

import org.apache.commons.autoconfig.commonconfig.config.datasource.CustomDataSourceConfig;
import org.apache.commons.autoconfig.commonconfig.config.datasource.MasterDataSourceConfig;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.transaction.ChainedTransactionManager;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.annotation.TransactionManagementConfigurer;

@Configuration
@ConditionalOnBean(value={MasterDataSourceConfig.class, CustomDataSourceConfig.class})
public class DataSourcesAutoConfiguration
implements TransactionManagementConfigurer {
    @Autowired
    @Qualifier(value="masterTransactionManager")
    private DataSourceTransactionManager masterTransactionManager;
    @Autowired
    @Qualifier(value="customTransactionManager")
    private DataSourceTransactionManager customTransactionManager;
    @Autowired
    @Qualifier(value="authTransactionManager")
    private DataSourceTransactionManager authTransactionManager;

    @Bean(name={"transactionManager"})
    public PlatformTransactionManager annotationDrivenTransactionManager() {
        ChainedTransactionManager platformTransactionManager = new ChainedTransactionManager(new PlatformTransactionManager[]{this.masterTransactionManager, this.customTransactionManager, this.authTransactionManager});
        return platformTransactionManager;
    }
}

