/*
 * Decompiled with CFR 0.152.
 */
package org.cg.common.avro;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.cg.common.avro.UTF8Serializer;
import org.codehaus.jackson.Version;
import org.codehaus.jackson.map.AnnotationIntrospector;
import org.codehaus.jackson.map.JsonSerializer;
import org.codehaus.jackson.map.MapperConfig;
import org.codehaus.jackson.map.Module;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.map.PropertyNamingStrategy;
import org.codehaus.jackson.map.introspect.AnnotatedClass;
import org.codehaus.jackson.map.introspect.AnnotatedField;
import org.codehaus.jackson.map.introspect.AnnotatedMethod;
import org.codehaus.jackson.map.introspect.JacksonAnnotationIntrospector;
import org.codehaus.jackson.map.module.SimpleModule;
import org.codehaus.jackson.map.ser.BeanPropertyFilter;
import org.codehaus.jackson.map.ser.FilterProvider;
import org.codehaus.jackson.map.ser.impl.SimpleBeanPropertyFilter;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public class BeanConvertor {
    private final ObjectMapper objectMapper = new ObjectMapper();
    private volatile boolean shouldFlattenKeys = true;
    private volatile boolean shouldNormalizeString = true;
    private volatile HashSet<String> mapNameSet = new HashSet();
    private volatile Object registered;

    public BeanConvertor(final String ... exclusions) {
        JacksonAnnotationIntrospector intr = new JacksonAnnotationIntrospector(){

            public Object findFilterId(AnnotatedClass ac) {
                Object id = super.findFilterId(ac);
                if (id == null) {
                    id = ac.getName();
                }
                return id;
            }
        };
        this.objectMapper.getSerializationConfig().setAnnotationIntrospector((AnnotationIntrospector)intr);
        this.objectMapper.getDeserializationConfig().setAnnotationIntrospector((AnnotationIntrospector)intr);
        this.objectMapper.setFilters(new FilterProvider(){

            public BeanPropertyFilter findFilter(Object filterId) {
                return SimpleBeanPropertyFilter.serializeAllExcept((String[])exclusions);
            }
        });
        this.objectMapper.setPropertyNamingStrategy(new PropertyNamingStrategy(){

            public String nameForField(MapperConfig<?> config, AnnotatedField field, String defaultName) {
                if (BeanConvertor.this.registered == null && field.getDeclaringClass().isAssignableFrom(Map.class)) {
                    BeanConvertor.this.mapNameSet.add(defaultName);
                }
                return super.nameForField(config, field, defaultName);
            }

            public String nameForGetterMethod(MapperConfig<?> config, AnnotatedMethod method, String defaultName) {
                if (BeanConvertor.this.registered == null && method.getRawType().isAssignableFrom(Map.class)) {
                    BeanConvertor.this.mapNameSet.add(defaultName);
                }
                return super.nameForGetterMethod(config, method, defaultName);
            }

            public String nameForSetterMethod(MapperConfig<?> config, AnnotatedMethod method, String defaultName) {
                if (method.getDeclaringClass().isAssignableFrom(Map.class)) {
                    BeanConvertor.this.mapNameSet.add(defaultName);
                }
                return super.nameForSetterMethod(config, method, defaultName);
            }
        });
        SimpleModule testModule = new SimpleModule("MyModule", new Version(1, 0, 0, null));
        testModule.addSerializer((JsonSerializer)new UTF8Serializer());
        this.objectMapper.registerModule((Module)testModule);
    }

    public void setShouldFlattenKeys(boolean shouldFlattenKeys) {
        this.shouldFlattenKeys = shouldFlattenKeys;
    }

    public boolean isShouldFlattenKeys() {
        return this.shouldFlattenKeys;
    }

    public boolean isShouldNormalizeString() {
        return this.shouldNormalizeString;
    }

    public void setShouldNormalizeString(boolean shouldNormalizeString) {
        this.shouldNormalizeString = shouldNormalizeString;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Object> transform(Object payload) {
        Map result = null;
        if (this.registered == null) {
            Class<BeanConvertor> clazz = BeanConvertor.class;
            synchronized (BeanConvertor.class) {
                if (this.registered == null) {
                    result = (Map)this.objectMapper.convertValue(payload, Map.class);
                    this.registered = new Object();
                } else {
                    result = (Map)this.objectMapper.convertValue(payload, Map.class);
                }
                // ** MonitorExit[var3_3] (shouldn't be in output)
            }
        } else {
            result = (Map)this.objectMapper.convertValue(payload, Map.class);
        }
        {
            if (this.shouldFlattenKeys) {
                result = this.flattenMap(result);
            }
            return result;
        }
    }

    private Map<String, Object> flattenMap(Map<String, Object> result) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        this.doFlatten("", result, resultMap);
        return resultMap;
    }

    private void doFlatten(String propertyPrefix, Map<String, Object> inputMap, Map<String, Object> resultMap) {
        if (StringUtils.hasText((String)propertyPrefix)) {
            propertyPrefix = propertyPrefix + ".";
        }
        for (String key : inputMap.keySet()) {
            Object value = inputMap.get(key);
            this.doProcessElement(propertyPrefix + key, value, resultMap);
        }
    }

    private void doFlattenMap(String propertyPrefix, Map<String, Object> inputMap, Map<String, Object> resultMap) {
        if (StringUtils.hasText((String)propertyPrefix)) {
            propertyPrefix = propertyPrefix + "[";
        }
        for (String key : inputMap.keySet()) {
            Object value = inputMap.get(key);
            this.doProcessElement(propertyPrefix + key + "]", value, resultMap);
        }
    }

    private void doProcessCollection(String propertyPrefix, Collection<?> list, Map<String, Object> resultMap) {
        int counter = 0;
        for (Object element : list) {
            this.doProcessElement(propertyPrefix + "[" + counter + "]", element, resultMap);
            ++counter;
        }
    }

    private void doProcessElement(String propertyPrefix, Object element, Map<String, Object> resultMap) {
        if (element instanceof Map) {
            int start = propertyPrefix.lastIndexOf(".");
            String key = propertyPrefix.substring(start + 1);
            if (this.mapNameSet.contains(key)) {
                this.doFlattenMap(propertyPrefix, (Map)element, resultMap);
            } else {
                this.doFlatten(propertyPrefix, (Map)element, resultMap);
            }
        } else if (element instanceof Collection) {
            this.doProcessCollection(propertyPrefix, (Collection)element, resultMap);
        } else if (element != null && element.getClass().isArray()) {
            List collection = CollectionUtils.arrayToList((Object)element);
            this.doProcessCollection(propertyPrefix, collection, resultMap);
        } else if (this.shouldNormalizeString) {
            if (element != null) {
                element = element.toString();
                resultMap.put(propertyPrefix, element);
            }
        } else {
            resultMap.put(propertyPrefix, element);
        }
    }
}

