/*
 * Decompiled with CFR 0.152.
 */
package org.cg.common.avro;

import java.util.Map;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.PropertyValues;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.support.DefaultConversionService;
import org.springframework.integration.transformer.MessageTransformationException;
import org.springframework.validation.DataBinder;

public class BeanGenerator {
    private Class<?> targetClass;

    public BeanGenerator(Class<?> targetClass) {
        try {
            this.targetClass = targetClass;
        }
        catch (Exception e) {
            throw new MessageTransformationException("can not create instance of " + targetClass, (Throwable)e);
        }
    }

    public Object transform(Map<?, ?> payload) {
        Object target = null;
        if (this.targetClass == null) {
            throw new MessageTransformationException("'targetClass or target 'beanName' must be specified");
        }
        target = BeanUtils.instantiate(this.targetClass);
        DataBinder binder = new DataBinder(target);
        binder.setConversionService((ConversionService)new DefaultConversionService());
        binder.bind((PropertyValues)new MutablePropertyValues(payload));
        return target;
    }
}

