/*
 * Decompiled with CFR 0.152.
 */
package org.cg.common.avro;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Proxy;
import java.net.URL;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSocketFactory;
import org.apache.avro.ipc.Transceiver;

public class HttpsTransceiver
extends Transceiver {
    private SSLSocketFactory factory;
    private HostnameVerifier verifier;
    static final String CONTENT_TYPE = "avro/binary";
    private URL url;
    private Proxy proxy;
    private HttpsURLConnection connection;
    private int timeout;

    public HttpsTransceiver(URL url, SSLSocketFactory fac, HostnameVerifier verifer) {
        this(url);
        this.factory = fac;
        this.verifier = verifer;
    }

    public HttpsTransceiver(URL url) {
        this.url = url;
    }

    public HttpsTransceiver(URL url, Proxy proxy) {
        this(url);
        this.proxy = proxy;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public String getRemoteName() {
        return this.url.toString();
    }

    public synchronized List<ByteBuffer> readBuffers() throws IOException {
        try (InputStream in = this.connection.getInputStream();){
            List<ByteBuffer> list = HttpsTransceiver.readBuffers(in);
            return list;
        }
    }

    public synchronized void writeBuffers(List<ByteBuffer> buffers) throws IOException {
        this.connection = this.proxy == null ? (HttpsURLConnection)this.url.openConnection() : (HttpsURLConnection)this.url.openConnection(this.proxy);
        this.connection.setHostnameVerifier(this.verifier);
        this.connection.setRequestMethod("POST");
        this.connection.setRequestProperty("Content-Type", CONTENT_TYPE);
        this.connection.setRequestProperty("Content-Length", Integer.toString(HttpsTransceiver.getLength(buffers)));
        this.connection.setDoOutput(true);
        this.connection.setReadTimeout(this.timeout);
        this.connection.setConnectTimeout(this.timeout);
        try (OutputStream out = this.connection.getOutputStream();){
            HttpsTransceiver.writeBuffers(buffers, out);
        }
    }

    static int getLength(List<ByteBuffer> buffers) {
        int length = 0;
        for (ByteBuffer buffer : buffers) {
            length += 4;
            length += buffer.remaining();
        }
        return length += 4;
    }

    static List<ByteBuffer> readBuffers(InputStream in) throws IOException {
        ArrayList<ByteBuffer> buffers = new ArrayList<ByteBuffer>();
        int length;
        while ((length = (in.read() << 24) + (in.read() << 16) + (in.read() << 8) + in.read()) != 0) {
            ByteBuffer buffer = ByteBuffer.allocate(length);
            while (buffer.hasRemaining()) {
                int p = buffer.position();
                int i = in.read(buffer.array(), p, buffer.remaining());
                if (i < 0) {
                    throw new EOFException("Unexpected EOF");
                }
                buffer.position(p + i);
            }
            buffer.flip();
            buffers.add(buffer);
        }
        return buffers;
    }

    static void writeBuffers(List<ByteBuffer> buffers, OutputStream out) throws IOException {
        for (ByteBuffer buffer : buffers) {
            HttpsTransceiver.writeLength(buffer.limit(), out);
            out.write(buffer.array(), buffer.position(), buffer.remaining());
            buffer.position(buffer.limit());
        }
        HttpsTransceiver.writeLength(0, out);
    }

    private static void writeLength(int length, OutputStream out) throws IOException {
        out.write(0xFF & length >>> 24);
        out.write(0xFF & length >>> 16);
        out.write(0xFF & length >>> 8);
        out.write(0xFF & length);
    }
}

