/*
 * Decompiled with CFR 0.152.
 */
package org.cg.common.flume;

import java.io.IOException;
import javax.servlet.Servlet;
import org.apache.avro.AvroRuntimeException;
import org.apache.avro.ipc.Responder;
import org.apache.avro.ipc.ResponderServlet;
import org.apache.avro.ipc.Server;
import org.cg.common.flume.HealthAwareResponderServlet;
import org.mortbay.jetty.Connector;
import org.mortbay.jetty.HandlerContainer;
import org.mortbay.jetty.nio.SelectChannelConnector;
import org.mortbay.jetty.servlet.Context;
import org.mortbay.jetty.servlet.ServletHolder;

public class InternalHttpServer
implements Server {
    private org.mortbay.jetty.Server server = new org.mortbay.jetty.Server();

    public InternalHttpServer(Responder responder, int port, int httpConnections) throws IOException {
        this(new HealthAwareResponderServlet(responder), null, port, httpConnections);
    }

    public InternalHttpServer(ResponderServlet servlet, int port, int httpConnections) throws IOException {
        this(servlet, null, port, httpConnections);
    }

    public InternalHttpServer(Responder responder, String bindAddress, int port, int httpConnections) throws IOException {
        this(new HealthAwareResponderServlet(responder), bindAddress, port, httpConnections);
    }

    public InternalHttpServer(ResponderServlet servlet, String bindAddress, int port, int httpConnections) throws IOException {
        SelectChannelConnector connector = new SelectChannelConnector();
        connector.setLowResourceMaxIdleTime(10000);
        connector.setAcceptQueueSize(128);
        connector.setResolveNames(false);
        connector.setUseDirectBuffers(false);
        connector.setAcceptors(httpConnections);
        if (bindAddress != null) {
            connector.setHost(bindAddress);
        }
        connector.setPort(port);
        this.server.addConnector((Connector)connector);
        new Context((HandlerContainer)this.server, "/").addServlet(new ServletHolder((Servlet)servlet), "/*");
    }

    public InternalHttpServer(Responder responder, Connector connector) throws IOException {
        this(new HealthAwareResponderServlet(responder), connector);
    }

    public InternalHttpServer(ResponderServlet servlet, Connector connector) throws IOException {
        this.server.addConnector(connector);
        new Context((HandlerContainer)this.server, "/").addServlet(new ServletHolder((Servlet)servlet), "/*");
    }

    public void addConnector(Connector connector) {
        this.server.addConnector(connector);
    }

    public int getPort() {
        return this.server.getConnectors()[0].getLocalPort();
    }

    public void close() {
        try {
            this.server.stop();
        }
        catch (Exception e) {
            throw new AvroRuntimeException((Throwable)e);
        }
    }

    public void start() {
        try {
            this.server.start();
        }
        catch (Exception e) {
            throw new AvroRuntimeException((Throwable)e);
        }
    }

    public void join() throws InterruptedException {
        this.server.join();
    }
}

