/*
 * Decompiled with CFR 0.152.
 */
package com.github.codeinghelper.auth;

import com.github.codeinghelper.auth.ActionRight;
import com.github.codeinghelper.auth.RightManager;
import com.github.codeinghelper.exception.http.ForbiddenException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.After;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Aspect
@Component
public class ActionRightvalidator {
    @Autowired
    RightManager rightManager;

    @Pointcut(value="@annotation(com.github.codeinghelper.auth.ActionRight)")
    private void permission() {
    }

    @Before(value="permission()&&@annotation(actionRight)")
    public void doBefore(JoinPoint joinPoint, ActionRight actionRight) {
        System.out.println("================== step 2: before ==================");
        System.out.println("******\u62e6\u622a\u524d\u7684\u903b\u8f91******");
        System.out.println("\u76ee\u6807\u65b9\u6cd5\u540d\u4e3a:" + joinPoint.getSignature().getName());
        System.out.println("\u76ee\u6807\u65b9\u6cd5\u6240\u5c5e\u7c7b\u7684\u7b80\u5355\u7c7b\u540d:" + joinPoint.getSignature().getDeclaringType().getSimpleName());
        System.out.println("\u76ee\u6807\u65b9\u6cd5\u6240\u5c5e\u7c7b\u7684\u7c7b\u540d:" + joinPoint.getSignature().getDeclaringTypeName());
        System.out.println("\u76ee\u6807\u65b9\u6cd5\u58f0\u660e\u7c7b\u578b:" + Modifier.toString(joinPoint.getSignature().getModifiers()));
        Object[] args = joinPoint.getArgs();
        for (int i = 0; i < args.length; ++i) {
            System.out.println("\u7b2c" + (i + 1) + "\u4e2a\u53c2\u6570\u4e3a:" + args[i]);
        }
        System.out.println("\u88ab\u4ee3\u7406\u7684\u5bf9\u8c61:" + joinPoint.getTarget());
        System.out.println("\u4ee3\u7406\u5bf9\u8c61\u81ea\u5df1:" + joinPoint.getThis());
        System.out.println("\u62e6\u622a\u7684\u6ce8\u89e3\u7684\u53c2\u6570\uff1a");
        System.out.println(actionRight.actionCode());
    }

    @After(value="permission()")
    public void doAfter() {
        System.out.println("================== step 4: after ==================");
    }

    @Around(value="permission()")
    public Object doAround(ProceedingJoinPoint proceedingJoinPoint) throws Throwable {
        System.out.println("================== step 1: around ==================");
        long startTime = System.currentTimeMillis();
        ServletRequestAttributes attributes = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
        HttpServletRequest request = attributes.getRequest();
        String token = request.getHeader("token");
        if (StringUtils.isEmpty((Object)token)) {
            throw new ForbiddenException(4003);
        }
        Map<String, String> map = this.rightManager.ActionRights();
        Method method = ((MethodSignature)proceedingJoinPoint.getSignature()).getMethod();
        ActionRight visitPermission = method.getAnnotation(ActionRight.class);
        String value = visitPermission.actionCode();
        Boolean require = visitPermission.require();
        if (require.booleanValue() && !map.containsKey(value)) {
            throw new ForbiddenException(4003);
        }
        System.out.println(value);
        Object result = proceedingJoinPoint.proceed();
        long endTime = System.currentTimeMillis();
        return result;
    }
}

