/*
 * Decompiled with CFR 0.152.
 */
package com.github.codeinghelper.jwt;

import com.auth0.jwt.JWT;
import com.auth0.jwt.JWTVerifier;
import com.auth0.jwt.algorithms.Algorithm;
import com.auth0.jwt.exceptions.JWTVerificationException;
import com.auth0.jwt.interfaces.Claim;
import com.auth0.jwt.interfaces.DecodedJWT;
import com.github.codeinghelper.exception.http.ServerErrorException;
import com.github.codeinghelper.util.DateUtil;
import com.github.codeinghelper.util.StringUtil;
import java.util.Map;
import java.util.Optional;

public class JwtToken {
    public static Optional<Map<String, Claim>> getClaims(String token, String jwtKey) {
        DecodedJWT decodedJWT;
        Algorithm algorithm = Algorithm.HMAC256((String)jwtKey);
        JWTVerifier jwtVerifier = JWT.require((Algorithm)algorithm).build();
        try {
            decodedJWT = jwtVerifier.verify(token);
        }
        catch (JWTVerificationException e) {
            return Optional.empty();
        }
        return Optional.of(decodedJWT.getClaims());
    }

    public static Boolean verifyToken(String token, String jwtKey) {
        try {
            Algorithm algorithm = Algorithm.HMAC256((String)jwtKey);
            JWTVerifier verifier = JWT.require((Algorithm)algorithm).build();
            verifier.verify(token);
        }
        catch (JWTVerificationException e) {
            return false;
        }
        return true;
    }

    public static String makeToken(String sessionId, String jwtKey, Integer expiredTimeIn) {
        if (StringUtil.isEmptyOrNull(sessionId) || StringUtil.isEmptyOrNull(jwtKey)) {
            throw new ServerErrorException(40002);
        }
        return JwtToken.getToken(sessionId, jwtKey, expiredTimeIn);
    }

    private static String getToken(String sessionId, String jwtKey, Integer expiredTimeIn) {
        Algorithm algorithm = Algorithm.HMAC256((String)jwtKey);
        return JWT.create().withClaim("sessionId", sessionId).withExpiresAt(DateUtil.addSeconds(expiredTimeIn)).withIssuedAt(DateUtil.getNow()).sign(algorithm);
    }
}

