/*
 * Decompiled with CFR 0.152.
 */
package httpclient;

import httpclient.HttpCallResponse;
import httpclient.RequestBody;
import java.io.IOException;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.HashMap;
import java.util.Map;

public class HttpCallRequest<T extends HttpCallRequest<T>> {
    private final HttpClient http;
    private String scheme = "https";
    private String hostname;
    private int port = -1;
    private String path;
    private String method = "GET";
    private Map<String, String> headers = new HashMap<String, String>();
    private HttpRequest.BodyPublisher body;

    public HttpCallRequest(HttpClient http) {
        this.http = http;
    }

    public T scheme(String scheme) {
        this.scheme = scheme;
        return (T)this;
    }

    public T hostname(String hostname) {
        this.hostname = hostname;
        return (T)this;
    }

    public T port(int port) {
        this.port = port;
        return (T)this;
    }

    public T uri(String uri) {
        return this.uri(URI.create(uri));
    }

    public T uri(URI uri) {
        this.scheme = uri.getScheme();
        this.hostname = uri.getHost();
        this.port = uri.getPort();
        this.path = uri.getPath();
        return (T)this;
    }

    public T method(String method, String path) {
        this.method = method;
        this.path = path;
        return (T)this;
    }

    public T get(String path) {
        this.method = "GET";
        this.path = path;
        return (T)this;
    }

    public T delete(String path) {
        this.method = "DELETE";
        this.path = path;
        return (T)this;
    }

    public T head(String path) {
        this.method = "HEAD";
        this.path = path;
        return (T)this;
    }

    public T post(String path) {
        this.method = "POST";
        this.path = path;
        return (T)this;
    }

    public T put(String path) {
        this.method = "PUT";
        this.path = path;
        return (T)this;
    }

    public T patch(String path) {
        this.method = "PATCH";
        this.path = path;
        return (T)this;
    }

    public T header(String name, String value) {
        this.headers.put(name, value);
        return (T)this;
    }

    public T contentType(String type) {
        this.headers.put("Content-Type", type);
        return (T)this;
    }

    public T body(HttpRequest.BodyPublisher body) {
        this.body = body;
        return (T)this;
    }

    public T body(RequestBody requestBody) {
        this.headers.putIfAbsent("Content-Type", requestBody.getHeader());
        this.body = requestBody.build();
        return (T)this;
    }

    public HttpCallResponse execute() throws IOException {
        return new HttpCallResponse(this.send(HttpResponse.BodyHandlers.ofString()));
    }

    public <U> HttpResponse<U> send(HttpResponse.BodyHandler<U> handler) throws IOException {
        try {
            URI uri = URI.create(this.scheme + "://" + this.hostname + this.getPort() + this.path);
            HttpRequest.Builder request = HttpRequest.newBuilder().uri(uri).method(this.method, this.body == null ? HttpRequest.BodyPublishers.noBody() : this.body);
            for (Map.Entry<String, String> entry : this.headers.entrySet()) {
                request.header(entry.getKey(), entry.getValue());
            }
            return this.http.send(request.build(), handler);
        }
        catch (InterruptedException e) {
            throw new IOException("Interrupted during IO", e);
        }
    }

    private String getPort() {
        return this.port == -1 ? "" : ":" + this.port;
    }
}

