/*
 * Decompiled with CFR 0.152.
 */
package httpclient;

import java.io.IOException;
import java.net.http.HttpResponse;
import java.util.function.Function;

public class HttpCallResponse<T extends HttpCallResponse<T>> {
    private final HttpResponse<String> response;

    public HttpCallResponse(HttpResponse<String> response) {
        this.response = response;
    }

    public T verifyNot404() throws IOException {
        if (this.response.statusCode() == 404) {
            throw new IOException("HTTP call returned 404 Not Found");
        }
        return (T)this;
    }

    public T verifyNotServerError() throws IOException {
        if (this.response.statusCode() >= 500 && this.response.statusCode() <= 599) {
            throw new IOException("Remote server error. Status code is " + this.response.statusCode() + " for " + String.valueOf(this.response.uri()));
        }
        return (T)this;
    }

    public T verifyStatusCode(int code) throws IOException {
        if (this.response.statusCode() != code) {
            throw new IOException("Wrong status code. Expected " + code + ", but was " + this.response.statusCode());
        }
        return (T)this;
    }

    public T verifySuccess() throws IOException {
        if (this.response.statusCode() < 200 || this.response.statusCode() > 299) {
            throw new IOException("Wrong status code. Expected 2XX, but was " + this.response.statusCode());
        }
        return (T)this;
    }

    public T verifySuccess(Function<HttpResponse<?>, ? extends IOException> supplier) throws IOException {
        if (this.response.statusCode() < 200 || this.response.statusCode() > 299) {
            throw supplier.apply(this.response);
        }
        return (T)this;
    }

    public T verify(Rule rule) throws IOException {
        rule.verify(this.response);
        return (T)this;
    }

    public <U> U fetchBodyInto(Serializer serializer, Class<U> clazz) throws IOException {
        return serializer.fromData(this.fetchBodyAsString(), clazz);
    }

    public <U> U fetchBodyWith(HttpBodyParser<U> converter) throws IOException {
        return converter.convert(this.fetchBodyAsString());
    }

    public String fetchBodyAsString() throws IOException {
        return this.response.body();
    }

    public static interface Rule {
        public void verify(HttpResponse<?> var1) throws IOException;
    }

    public static interface Serializer {
        public <U> U fromData(String var1, Class<U> var2);
    }

    public static interface HttpBodyParser<U> {
        public U convert(String var1) throws IOException;
    }
}

