/*
 * Decompiled with CFR 0.152.
 */
package httpclient;

import httpclient.RequestBody;
import java.net.URLEncoder;
import java.net.http.HttpRequest;
import java.nio.charset.StandardCharsets;

public final class URLEncodedForm
implements RequestBody {
    private final StringBuilder builder = new StringBuilder();

    public static URLEncodedForm newFormBody() {
        return new URLEncodedForm();
    }

    @Override
    public String getHeader() {
        return "application/x-www-form-urlencoded";
    }

    public URLEncodedForm add(String name, String value) {
        if (this.builder.length() > 0) {
            this.builder.append("&");
        }
        this.builder.append(URLEncodedForm.encodeUrl(name)).append("=").append(URLEncodedForm.encodeUrl(value));
        return this;
    }

    @Override
    public HttpRequest.BodyPublisher build() {
        return HttpRequest.BodyPublishers.ofString(this.builder.toString());
    }

    private static String encodeUrl(String value) {
        return value != null ? URLEncoder.encode(value, StandardCharsets.UTF_8) : "";
    }
}

