/*
 * Decompiled with CFR 0.152.
 */
package httpclient;

import httpclient.HeaderStrategy;
import httpclient.HttpCallResponse;
import httpclient.RequestBody;
import httpclient.Serializers;
import java.io.IOException;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.HashMap;
import java.util.Map;

public final class HttpCallRequest {
    private final HttpClient http;
    private final Serializers serializers;
    private final boolean silentRemoveNullHeaders;
    private String scheme = "https";
    private String hostname;
    private int port = -1;
    private String path;
    private String method = "GET";
    private Map<String, String> headers = new HashMap<String, String>();
    private HttpRequest.BodyPublisher body;

    public HttpCallRequest(HttpClient httpClient) {
        this(httpClient, new Serializers.Builder().build(), HeaderStrategy.THROW_EXCEPTION_ON_NULL);
    }

    public HttpCallRequest(HttpClient httpClient, HeaderStrategy headerStrategy) {
        this(httpClient, new Serializers.Builder().build(), headerStrategy);
    }

    public HttpCallRequest(HttpClient httpClient, Serializers serializers, HeaderStrategy headerStrategy) {
        this.http = httpClient;
        this.serializers = serializers;
        this.silentRemoveNullHeaders = headerStrategy == HeaderStrategy.SILENT_REMOVE_NULL_HEADERS;
    }

    public HttpCallRequest scheme(String string) {
        this.scheme = string;
        return this;
    }

    public HttpCallRequest hostname(String string) {
        this.hostname = string;
        return this;
    }

    public HttpCallRequest port(int n) {
        this.port = n;
        return this;
    }

    public HttpCallRequest uri(String string) {
        return this.uri(URI.create(string));
    }

    public HttpCallRequest uri(URI uRI) {
        this.scheme = uRI.getScheme();
        this.hostname = uRI.getHost();
        this.port = uRI.getPort();
        this.path = uRI.getPath();
        return this;
    }

    public HttpCallRequest method(String string) {
        this.method = string;
        return this;
    }

    public HttpCallRequest method(String string, String string2) {
        this.method = string;
        this.path = string2;
        return this;
    }

    public HttpCallRequest get() {
        this.method = "GET";
        return this;
    }

    public HttpCallRequest get(String string) {
        this.method = "GET";
        this.path = string;
        return this;
    }

    public HttpCallRequest delete() {
        this.method = "DELETE";
        return this;
    }

    public HttpCallRequest delete(String string) {
        this.method = "DELETE";
        this.path = string;
        return this;
    }

    public HttpCallRequest head() {
        this.method = "HEAD";
        return this;
    }

    public HttpCallRequest head(String string) {
        this.method = "HEAD";
        this.path = string;
        return this;
    }

    public HttpCallRequest post() {
        this.method = "POST";
        return this;
    }

    public HttpCallRequest post(String string) {
        this.method = "POST";
        this.path = string;
        return this;
    }

    public HttpCallRequest put() {
        this.method = "PUT";
        return this;
    }

    public HttpCallRequest put(String string) {
        this.method = "PUT";
        this.path = string;
        return this;
    }

    public HttpCallRequest patch() {
        this.method = "PATCH";
        return this;
    }

    public HttpCallRequest patch(String string) {
        this.method = "PATCH";
        this.path = string;
        return this;
    }

    public HttpCallRequest header(String string, String string2) {
        if (string == null || string.isEmpty()) {
            if (this.silentRemoveNullHeaders) {
                return this;
            }
            throw new IllegalArgumentException("Header name is null or empty");
        }
        if (string2 == null) {
            if (this.silentRemoveNullHeaders) {
                return this;
            }
            throw new IllegalArgumentException("Header value for '" + string + "' is null");
        }
        this.headers.put(string, string2);
        return this;
    }

    public HttpCallRequest contentType(String string) {
        this.headers.put("Content-Type", string);
        return this;
    }

    public HttpCallRequest body(String string) {
        return this.body(HttpRequest.BodyPublishers.ofString(string));
    }

    public HttpCallRequest body(HttpRequest.BodyPublisher bodyPublisher) {
        this.body = bodyPublisher;
        return this;
    }

    public HttpCallRequest body(RequestBody requestBody) {
        this.headers.putIfAbsent("Content-Type", requestBody.getHeader());
        this.body = requestBody.build();
        return this;
    }

    public HttpCallResponse execute() throws IOException {
        return new HttpCallResponse(this.serializers, this.send(HttpResponse.BodyHandlers.ofByteArray()));
    }

    public <U> HttpResponse<U> send(HttpResponse.BodyHandler<U> bodyHandler) throws IOException {
        try {
            URI uRI = URI.create(this.scheme + "://" + this.hostname + this.getPort() + this.path);
            HttpRequest.Builder builder = HttpRequest.newBuilder().uri(uRI).method(this.method, this.body == null ? HttpRequest.BodyPublishers.noBody() : this.body);
            for (Map.Entry<String, String> entry : this.headers.entrySet()) {
                builder.header(entry.getKey(), entry.getValue());
            }
            return this.http.send(builder.build(), bodyHandler);
        }
        catch (InterruptedException interruptedException) {
            throw new IOException("Interrupted during IO", interruptedException);
        }
    }

    private String getPort() {
        return this.port == -1 ? "" : ":" + this.port;
    }
}

