/*
 * Decompiled with CFR 0.152.
 */
package httpclient;

import httpclient.ResponseBodyParser;
import httpclient.Serializers;
import java.io.IOException;
import java.net.http.HttpResponse;
import java.nio.charset.Charset;
import java.util.Optional;
import java.util.function.Function;

public class HttpCallResponse {
    private final Serializers serializers;
    private final HttpResponse<byte[]> response;

    public HttpCallResponse(Serializers serializers, HttpResponse<byte[]> httpResponse) {
        this.serializers = serializers;
        this.response = httpResponse;
    }

    public HttpCallResponse verifyNot404() throws IOException {
        if (this.response.statusCode() == 404) {
            throw new IOException("HTTP call returned 404 Not Found");
        }
        return this;
    }

    public HttpCallResponse verifyNotServerError() throws IOException {
        if (this.response.statusCode() >= 500 && this.response.statusCode() <= 599) {
            throw new IOException("Remote server error. Status code is " + this.response.statusCode() + " for " + String.valueOf(this.response.uri()));
        }
        return this;
    }

    public HttpCallResponse verifyStatusCode(int n) throws IOException {
        if (this.response.statusCode() != n) {
            throw new IOException("Wrong status code. Expected " + n + ", but was " + this.response.statusCode());
        }
        return this;
    }

    public HttpCallResponse verifySuccess() throws IOException {
        if (this.response.statusCode() < 200 || this.response.statusCode() > 299) {
            throw new IOException("Wrong status code. Expected 2XX, but was " + this.response.statusCode());
        }
        return this;
    }

    public HttpCallResponse verifySuccess(Function<HttpResponse<?>, ? extends IOException> function) throws IOException {
        if (this.response.statusCode() < 200 || this.response.statusCode() > 299) {
            throw function.apply(this.response);
        }
        return this;
    }

    public HttpCallResponse verify(Rule rule) throws IOException {
        rule.verify(this.response);
        return this;
    }

    public <U> U fetchBodyInto(Class<U> clazz) throws IOException {
        Optional<String> optional = this.response.headers().firstValue("Content-Type");
        if (optional.isEmpty()) {
            throw new IOException("Content-Type missing from response");
        }
        Serializers.Serializer serializer = this.serializers.getFromHeader(optional.get());
        if (serializer == null) {
            throw new IOException("No serializer available for type: " + optional.get());
        }
        return serializer.fromData(this.response.body(), clazz);
    }

    public <U> U fetchBodyInto(Serializers.Serializer serializer, Class<U> clazz) throws IOException {
        return serializer.fromData(this.response.body(), clazz);
    }

    public <U> U fetchBodyWith(ResponseBodyParser<U> responseBodyParser) throws IOException {
        return responseBodyParser.parse(this.response.body());
    }

    public byte[] fetchBody() throws IOException {
        return this.response.body();
    }

    public String fetchBodyAsString(Charset charset) throws IOException {
        return new String(this.response.body(), charset);
    }

    public HttpResponse<byte[]> response() {
        return this.response;
    }

    public static interface Rule {
        public void verify(HttpResponse<?> var1) throws IOException;
    }
}

