/*
 * Decompiled with CFR 0.152.
 */
package httpclient;

import httpclient.RequestBody;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.http.HttpRequest;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;

public final class MultipartForm
implements RequestBody {
    private final HashMap<String, byte[]> data = new HashMap();
    private String boundary = null;
    private static final char[] HEX_CHARS = "0123456789abcdef".toCharArray();
    private static final byte[] CRLF = "\r\n".getBytes(StandardCharsets.US_ASCII);

    public MultipartForm add(String string, byte[] byArray) {
        this.data.put(string, byArray);
        return this;
    }

    @Override
    public String getHeader() {
        if (this.boundary == null) {
            this.boundary = "----" + MultipartForm.randomHexData(20);
        }
        return "multipart/form-data; boundary=" + this.boundary;
    }

    private static String randomHexData(int n) {
        byte[] byArray = new byte[n];
        new Random().nextBytes(byArray);
        return MultipartForm.encodeHex(byArray);
    }

    private static String encodeHex(byte[] byArray) {
        char[] cArray = new char[byArray.length * 2];
        for (int i = 0; i < byArray.length; ++i) {
            int n = byArray[i] & 0xFF;
            cArray[i * 2] = HEX_CHARS[n >>> 4];
            cArray[i * 2 + 1] = HEX_CHARS[n & 0xF];
        }
        return new String(cArray);
    }

    @Override
    public HttpRequest.BodyPublisher build() {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byte[] byArray = ("--" + this.boundary).getBytes(StandardCharsets.US_ASCII);
        try {
            byteArrayOutputStream.write(byArray);
            for (Map.Entry<String, byte[]> entry : this.data.entrySet()) {
                byteArrayOutputStream.write(CRLF);
                byteArrayOutputStream.write(("Content-Disposition: form-data; name=\"" + entry.getKey() + "\"").getBytes(StandardCharsets.US_ASCII));
                byteArrayOutputStream.write(CRLF);
                byte[] byArray2 = entry.getValue();
                byteArrayOutputStream.write(("Content-Length: " + byArray2.length).getBytes(StandardCharsets.US_ASCII));
                byteArrayOutputStream.write(CRLF);
                byteArrayOutputStream.write(CRLF);
                byteArrayOutputStream.write(byArray2);
                byteArrayOutputStream.write(CRLF);
                byteArrayOutputStream.write(byArray);
            }
            byteArrayOutputStream.write("--".getBytes(StandardCharsets.US_ASCII));
            return HttpRequest.BodyPublishers.ofByteArray(byteArrayOutputStream.toByteArray());
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }
}

