/*
 * Decompiled with CFR 0.152.
 */
package httpclient;

import java.util.HashMap;
import java.util.Map;

public final class Serializers {
    private final Serializer json;
    private final Serializer xml;
    private final Map<String, Serializer> types;

    public Serializers(Serializer serializer, Serializer serializer2, Map<String, Serializer> map) {
        this.json = serializer;
        this.xml = serializer2;
        this.types = map;
    }

    public Serializer getFromFormat(Format format) {
        switch (format) {
            case json: {
                return this.json;
            }
            case xml: {
                return this.xml;
            }
        }
        throw new IllegalArgumentException("Unknown format: " + String.valueOf((Object)format));
    }

    public Serializer getFromHeader(String string) {
        return this.types.get(string);
    }

    public static interface Serializer {
        public <U> U fromData(byte[] var1, Class<U> var2);
    }

    public static enum Format {
        json,
        xml;

    }

    public static class Builder {
        private Serializer json;
        private Serializer xml;
        private Map<String, Serializer> types = new HashMap<String, Serializer>();

        public Builder json(Serializer serializer) {
            this.json = serializer;
            this.types.put("application/json", serializer);
            this.types.put("application/json; charset=utf-8", serializer);
            return this;
        }

        public Builder xml(Serializer serializer) {
            this.xml = serializer;
            return this;
        }

        public Builder type(String string, Serializer serializer) {
            this.types.put(string, serializer);
            return this;
        }

        public Serializers build() {
            return new Serializers(this.json, this.xml, this.types);
        }
    }
}

