/*
 * Decompiled with CFR 0.152.
 */
package httpclient;

import httpclient.RequestBody;
import java.net.URLEncoder;
import java.net.http.HttpRequest;
import java.nio.charset.StandardCharsets;

public final class URLEncodedForm
implements RequestBody {
    private final StringBuilder builder = new StringBuilder();

    public static URLEncodedForm newFormBody() {
        return new URLEncodedForm();
    }

    @Override
    public String getHeader() {
        return "application/x-www-form-urlencoded";
    }

    public URLEncodedForm add(String string, String string2) {
        if (this.builder.length() > 0) {
            this.builder.append("&");
        }
        this.builder.append(URLEncodedForm.encodeUrl(string)).append("=").append(URLEncodedForm.encodeUrl(string2));
        return this;
    }

    @Override
    public HttpRequest.BodyPublisher build() {
        return HttpRequest.BodyPublishers.ofString(this.builder.toString());
    }

    private static String encodeUrl(String string) {
        return string != null ? URLEncoder.encode(string, StandardCharsets.UTF_8) : "";
    }
}

