/*
 * Decompiled with CFR 0.152.
 */
package httpserver.core;

import httpserver.HttpHandler;
import httpserver.HttpServer;
import httpserver.core.HttpServerExchange;
import httpserver.core.RequestParsing;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;

public class HttpServerBuilder {
    private int port = 8080;
    private int backlog = 100;
    private boolean daemon = false;
    private String address = "0.0.0.0";
    private HttpHandler handler;
    private int maxRequestSize = 8192;
    private Executor executor;

    public HttpServerBuilder bind(int port, String address) {
        if (port < 0 || port > 65535) {
            throw new IllegalArgumentException("port value must be between 0 and 65535");
        }
        this.port = port;
        this.address = address;
        return this;
    }

    public HttpServerBuilder executor(Executor executor) {
        this.executor = executor;
        return this;
    }

    public HttpServerBuilder backlog(int backlog) {
        if (backlog < 0) {
            throw new IllegalArgumentException("Number of waiting connections must be a positive number");
        }
        this.backlog = backlog;
        return this;
    }

    public HttpServerBuilder daemon(boolean daemon) {
        this.daemon = daemon;
        return this;
    }

    public HttpServerBuilder maxRequestHeadSize(int maxRequestSize) {
        if (maxRequestSize <= 1024) {
            throw new IllegalArgumentException("Max request size must be larger than or equal to 1024");
        }
        this.maxRequestSize = maxRequestSize;
        return this;
    }

    public HttpServerBuilder handler(HttpHandler handler) {
        this.handler = handler;
        return this;
    }

    public HttpServer build() throws UnknownHostException {
        InetAddress bindAddress = InetAddress.getByName(this.address);
        Executor exec = this.executor != null ? this.executor : Executors.newVirtualThreadPerTaskExecutor();
        return new HttpServer(this.port, bindAddress, this.daemon, this.backlog, exec, (in, out) -> {
            byte[] data = new byte[this.maxRequestSize];
            HttpServerExchange exchange = new HttpServerExchange(data, RequestParsing.readRequestHead(data, in), in, out);
            try {
                this.handler.handleRequest(exchange);
            }
            catch (Exception e) {
                exchange.setStatusCode(500);
            }
            finally {
                RequestParsing.discardRemainingRequestBody(exchange);
                exchange.sendResponse();
                HttpServerBuilder.ifNeededCloseConnection(exchange);
            }
        });
    }

    private static void ifNeededCloseConnection(HttpServerExchange exchange) throws IOException {
        if ("HTTP/0.9".equals(exchange.getRequestProtocol())) {
            throw new IOException("HTTP/0.9 closing connection");
        }
        if ("HTTP/1.0".equals(exchange.getRequestProtocol()) && !"keep-alive".equals(exchange.getRequestHeader("Connection"))) {
            throw new IOException("HTTP/1.0 closing connection");
        }
        if ("HTTP/1.1".equals(exchange.getRequestProtocol()) && "close".equals(exchange.getRequestHeader("Connection"))) {
            throw new IOException("HTTP/1.1 closing connection");
        }
    }
}

