/*
 * Decompiled with CFR 0.152.
 */
package httpserver.core;

import httpserver.core.ResponseBody;
import httpserver.core.StatusCode;
import httpserver.util.Encoding;
import httpserver.util.LengthRestrictedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class HttpServerExchange {
    private final byte[] rawRequest;
    private final String method;
    private final String uri;
    private final String protocol;
    private final List<String> headers;
    private final InputStream in;
    private final OutputStream out;
    private String path;
    private Map<String, String> queryParameters;
    private int statusCode = 200;
    private String statusMessage;
    private final Map<String, String> responseHeaders = new HashMap<String, String>();
    private ResponseBody responseBody = ResponseBody.EMPTY_BODY;
    private boolean noContentLength = false;
    private boolean responseSent = false;
    private static final DateTimeFormatter DATE_FORMAT = DateTimeFormatter.ofPattern("EEE, dd MMM yyyy HH:mm:ss z", Locale.ENGLISH).withZone(ZoneId.of("GMT"));

    public HttpServerExchange(byte[] request, int length, InputStream in, OutputStream out) throws IOException {
        this.rawRequest = request;
        this.in = in;
        this.out = out;
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(new ByteArrayInputStream(request, 0, length)));){
            String headerLine;
            String firstLine = reader.readLine();
            int firstSpaceOffset = firstLine.indexOf(32);
            int secondSpaceOffset = firstLine.indexOf(32, firstSpaceOffset + 1);
            this.method = firstLine.substring(0, firstSpaceOffset);
            if (secondSpaceOffset != -1) {
                this.uri = firstLine.substring(firstSpaceOffset + 1, secondSpaceOffset);
                this.protocol = firstLine.substring(secondSpaceOffset + 1);
            } else {
                this.uri = firstLine.substring(firstSpaceOffset + 1);
                this.protocol = "HTTP/0.9";
            }
            if ("HTTP/1.0".equals(this.protocol)) {
                this.responseHeaders.put("Connection", "keep-alive");
            }
            this.headers = new ArrayList<String>();
            while ((headerLine = reader.readLine()) != null) {
                if (headerLine.isEmpty()) {
                    break;
                }
                this.headers.add(headerLine);
            }
        }
    }

    public byte[] getRawRequest() {
        return this.rawRequest;
    }

    public String getRequestMethod() {
        return this.method;
    }

    public String getRequestURI() {
        return this.uri;
    }

    public String getRequestProtocol() {
        return this.protocol;
    }

    public String getRequestHeader(String name) {
        String searchName = name.toLowerCase() + ": ";
        for (String header : this.headers) {
            if (!header.toLowerCase().startsWith(searchName)) continue;
            return header.substring(name.length() + ": ".length());
        }
        return null;
    }

    public List<String> getRequestHeaders(String name) {
        ArrayList<String> headers = new ArrayList<String>();
        String searchName = name.toLowerCase() + ": ";
        for (String header : this.headers) {
            if (!header.toLowerCase().startsWith(searchName)) continue;
            headers.add(header.substring(name.length() + ": ".length()));
        }
        return headers;
    }

    public String getRequestPath() {
        if (this.path != null) {
            return this.path;
        }
        int questionOffset = this.uri.indexOf(63);
        this.path = this.uri.substring(0, questionOffset != -1 ? questionOffset : this.uri.length());
        return this.path;
    }

    public String getQueryParameter(String name) {
        String[] parameters;
        if (this.queryParameters != null) {
            return this.queryParameters.get(name);
        }
        this.queryParameters = new HashMap<String, String>();
        int questionOffset = this.uri.indexOf(63);
        if (questionOffset == -1) {
            return null;
        }
        for (String paramPair : parameters = this.uri.substring(questionOffset + 1).split("&")) {
            int equalsOffset = paramPair.indexOf(61);
            if (equalsOffset == -1) {
                this.queryParameters.put(paramPair, "");
                continue;
            }
            String paramName = Encoding.decodeUrl(paramPair.substring(0, equalsOffset));
            String paramValue = Encoding.decodeUrl(paramPair.substring(equalsOffset + 1));
            this.queryParameters.put(paramName, paramValue);
        }
        return this.queryParameters.get(name);
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public void setStatusCode(int code) {
        this.statusCode = code;
    }

    public String getStatusMessage() {
        return this.statusMessage;
    }

    public void setStatusMessage(String statusMessage) {
        this.statusMessage = statusMessage;
    }

    public String getResponseHeader(String name) {
        return this.responseHeaders.get(name);
    }

    public void setResponseHeader(String name, String value) {
        this.responseHeaders.put(name, value);
    }

    public void removeResponseHeader(String name) {
        this.responseHeaders.remove(name);
    }

    public void setNoContentLength() {
        this.noContentLength = true;
    }

    public void send(String data, Charset charset) {
        this.send(data.getBytes(charset));
    }

    public void send(byte[] data) {
        this.responseBody = ResponseBody.newByteArrayBody(data);
    }

    public void send(byte[] data, int offset, int length) {
        this.responseBody = ResponseBody.newByteArrayBody(data, offset, length);
    }

    public void send(InputStream in, long length) {
        this.responseBody = ResponseBody.newInputStreamBody(in, length);
    }

    public InputStream getInputStream() {
        String contentLength = this.getRequestHeader("Content-Length");
        if (contentLength == null) {
            return new ByteArrayInputStream(new byte[0]);
        }
        long length = Long.parseLong(contentLength);
        return new LengthRestrictedInputStream(this.in, length);
    }

    public OutputStream getOutputStream() {
        return this.out;
    }

    public void sendResponse() throws IOException {
        if (!this.responseSent) {
            if (this.shouldSendHeadResponse()) {
                PrintWriter writer = new PrintWriter(this.out);
                writer.println(this.protocol + " " + this.statusCode + " " + StatusCode.getMessageForCode(this.statusCode, this.statusMessage));
                for (Map.Entry<String, String> header : this.responseHeaders.entrySet()) {
                    writer.println(header.getKey() + ": " + header.getValue());
                }
                if (!this.noContentLength && this.methodAllowsResponseBody() && !this.responseHeaders.containsKey("Content-Length")) {
                    writer.println("Content-Length: " + this.responseBody.getLength());
                }
                if (!this.responseHeaders.containsKey("Date")) {
                    writer.println("Date: " + DATE_FORMAT.format(Instant.now()));
                }
                writer.print("\r\n");
                writer.flush();
            }
            if (this.methodAllowsResponseBody()) {
                this.responseBody.writeTo(this.out);
            }
            this.responseSent = true;
        }
    }

    public boolean isResponseSent() {
        return this.responseSent;
    }

    public ResponseBody getResponseBody() {
        return this.responseBody;
    }

    public boolean methodAllowsResponseBody() {
        return !"HEAD".equals(this.method);
    }

    private boolean shouldSendHeadResponse() throws IOException {
        if ("HTTP/0.9".equals(this.protocol)) {
            return false;
        }
        if ("HTTP/1.0".equals(this.protocol)) {
            return true;
        }
        if ("HTTP/1.1".equals(this.protocol)) {
            return true;
        }
        throw new IOException("HTTP protocol not recognised");
    }
}

