/*
 * Decompiled with CFR 0.152.
 */
package httpserver.handlers;

import httpserver.HttpHandler;
import httpserver.core.HttpServerExchange;
import java.util.HashMap;
import java.util.Map;

public class MethodPathRouting
implements HttpHandler {
    private final Map<String, Map<String, HttpHandler>> routes = new HashMap<String, Map<String, HttpHandler>>();
    private HttpHandler fallback = exchange -> exchange.setStatusCode(404);

    public static MethodPathRouting methodPathRouting() {
        return new MethodPathRouting();
    }

    public MethodPathRouting fallback(HttpHandler fallback) {
        this.fallback = fallback;
        return this;
    }

    public MethodPathRouting head(String path, HttpHandler handler) {
        this.routes.computeIfAbsent("HEAD", s -> new HashMap()).put(path, handler);
        return this;
    }

    public MethodPathRouting get(String path, HttpHandler handler) {
        this.routes.computeIfAbsent("GET", s -> new HashMap()).put(path, handler);
        return this;
    }

    public MethodPathRouting put(String path, HttpHandler handler) {
        this.routes.computeIfAbsent("PUT", s -> new HashMap()).put(path, handler);
        return this;
    }

    public MethodPathRouting post(String path, HttpHandler handler) {
        this.routes.computeIfAbsent("POST", s -> new HashMap()).put(path, handler);
        return this;
    }

    public MethodPathRouting patch(String path, HttpHandler handler) {
        this.routes.computeIfAbsent("PATCH", s -> new HashMap()).put(path, handler);
        return this;
    }

    public MethodPathRouting delete(String path, HttpHandler handler) {
        this.routes.computeIfAbsent("DELETE", s -> new HashMap()).put(path, handler);
        return this;
    }

    @Override
    public void handleRequest(HttpServerExchange exchange) throws Exception {
        Map<String, HttpHandler> map = this.routes.get(exchange.getRequestMethod());
        HttpHandler handler = map == null ? this.fallback : map.getOrDefault(exchange.getRequestPath(), this.fallback);
        handler.handleRequest(exchange);
    }
}

