/*
 * Decompiled with CFR 0.152.
 */
package httpserver.util;

import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.text.StringCharacterIterator;

public final class Encoding
extends Enum<Encoding> {
    private static final /* synthetic */ Encoding[] $VALUES;

    public static Encoding[] values() {
        return (Encoding[])$VALUES.clone();
    }

    public static Encoding valueOf(String name) {
        return Enum.valueOf(Encoding.class, name);
    }

    public static String encodeUrl(String value) {
        return value != null ? URLEncoder.encode(value, StandardCharsets.UTF_8) : "";
    }

    public static String decodeUrl(String value) {
        return value != null ? URLDecoder.decode(value, StandardCharsets.UTF_8) : "";
    }

    public static String escapeJson(String input) {
        if (input == null) {
            return "";
        }
        StringBuilder ret = new StringBuilder();
        StringCharacterIterator iterator = new StringCharacterIterator(input);
        char c = iterator.current();
        while (c != '\uffff') {
            switch (c) {
                case '\"': {
                    ret.append("\\\"");
                    break;
                }
                case '\t': {
                    ret.append("\\t");
                    break;
                }
                case '\f': {
                    ret.append("\\f");
                    break;
                }
                case '\n': {
                    ret.append("\\n");
                    break;
                }
                case '\r': {
                    ret.append("\\r");
                    break;
                }
                case '\\': {
                    ret.append("\\\\");
                    break;
                }
                case '/': {
                    ret.append("\\/");
                    break;
                }
                case '\b': {
                    ret.append("\\b");
                    break;
                }
                default: {
                    ret.append(c);
                }
            }
            c = iterator.next();
        }
        return ret.toString();
    }

    private static /* synthetic */ Encoding[] $values() {
        return new Encoding[0];
    }

    static {
        $VALUES = Encoding.$values();
    }
}

