/*
 * Decompiled with CFR 0.152.
 */
package httpserver.core;

import httpserver.core.HttpServerExchange;
import httpserver.error.InvalidInput;
import java.io.IOException;
import java.util.List;

public interface SessionStore<T> {
    default public String getSessionCookieName() {
        return "session";
    }

    default public String getSessionCookieConfiguration() {
        return "; Path=/; Secure; HttpOnly; SameSite=strict";
    }

    public void setSession(HttpServerExchange var1, T var2) throws IOException;

    public boolean existsSession(HttpServerExchange var1) throws IOException, InvalidInput;

    public T getSession(HttpServerExchange var1) throws IOException, InvalidInput;

    public T getSession(HttpServerExchange var1, T var2) throws IOException, InvalidInput;

    public void deleteSession(HttpServerExchange var1) throws IOException;

    public static String getValueForCookie(HttpServerExchange httpServerExchange, String string) {
        List<String> list = httpServerExchange.getRequestHeaders("Cookie");
        if (list == null || list.isEmpty()) {
            return null;
        }
        String string2 = string + "=";
        for (String string3 : list) {
            for (String string4 : string3.split(";")) {
                if (!string4.trim().startsWith(string2)) continue;
                return string4.substring(string4.indexOf(61) + 1).trim();
            }
        }
        return null;
    }
}

