/*
 * Decompiled with CFR 0.152.
 */
package httpserver.core;

import httpserver.HttpHandler;
import httpserver.HttpServer;
import httpserver.core.HttpServerExchange;
import httpserver.core.RequestParsing;
import httpserver.util.Value;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;

public class HttpServerBuilder {
    private int port = 8080;
    private int backlog = 100;
    private boolean daemon = false;
    private String address = "0.0.0.0";
    private HttpHandler handler;
    private int maxRequestSize = 8192;
    private Executor executor;

    public HttpServerBuilder bind(int n, String string) {
        if (n < 0 || n > 65535) {
            throw new IllegalArgumentException("port value must be between 0 and 65535");
        }
        this.port = n;
        this.address = string;
        return this;
    }

    public HttpServerBuilder executor(Executor executor) {
        this.executor = executor;
        return this;
    }

    public HttpServerBuilder backlog(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("Number of waiting connections must be a positive number");
        }
        this.backlog = n;
        return this;
    }

    public HttpServerBuilder daemon(boolean bl) {
        this.daemon = bl;
        return this;
    }

    public HttpServerBuilder maxRequestHeadSize(int n) {
        if (n <= 1024) {
            throw new IllegalArgumentException("Max request size must be larger than or equal to 1024");
        }
        this.maxRequestSize = n;
        return this;
    }

    public HttpServerBuilder handler(HttpHandler httpHandler) {
        this.handler = httpHandler;
        return this;
    }

    public HttpServer build() throws UnknownHostException {
        InetAddress inetAddress = InetAddress.getByName(this.address);
        Executor executor = this.executor != null ? this.executor : Executors.newFixedThreadPool(10);
        return new HttpServer(this.port, inetAddress, this.daemon, this.backlog, executor, (socket, inputStream, outputStream) -> {
            byte[] byArray = new byte[this.maxRequestSize];
            HttpServerExchange httpServerExchange = new HttpServerExchange(socket, byArray, RequestParsing.readRequestHead(byArray, inputStream), inputStream, outputStream);
            Value value = new Value();
            try {
                this.handler.handleRequest(httpServerExchange);
            }
            catch (Exception exception) {
                value.value = exception;
                httpServerExchange.setStatusCode(500);
            }
            finally {
                RequestParsing.discardRemainingRequestBody(httpServerExchange);
                httpServerExchange.sendResponse();
                HttpServerBuilder.ifNeededCloseConnection(httpServerExchange);
                httpServerExchange.notifyCompleteListeners((Exception)value.value);
            }
        });
    }

    private static void ifNeededCloseConnection(HttpServerExchange httpServerExchange) throws IOException {
        if ("HTTP/0.9".equals(httpServerExchange.getRequestProtocol())) {
            throw new IOException("HTTP/0.9 closing connection");
        }
        if ("HTTP/1.0".equals(httpServerExchange.getRequestProtocol()) && !"keep-alive".equals(httpServerExchange.getRequestHeader("Connection"))) {
            throw new IOException("HTTP/1.0 closing connection");
        }
        if ("HTTP/1.1".equals(httpServerExchange.getRequestProtocol()) && "close".equals(httpServerExchange.getRequestHeader("Connection"))) {
            throw new IOException("HTTP/1.1 closing connection");
        }
    }
}

