/*
 * Decompiled with CFR 0.152.
 */
package httpserver.handlers;

import httpserver.HttpHandler;
import httpserver.caching.CacheControlStrategy;
import httpserver.core.ContentType;
import httpserver.core.HttpServerExchange;
import httpserver.core.ResponseBuilder;
import httpserver.error.HttpError;
import httpserver.util.Encoding;
import java.nio.charset.StandardCharsets;

public final class Common
extends Enum<Common> {
    private static final /* synthetic */ Common[] $VALUES;

    public static Common[] values() {
        return (Common[])$VALUES.clone();
    }

    public static Common valueOf(String string) {
        return Enum.valueOf(Common.class, string);
    }

    public static HttpHandler staticHtml(String string) {
        String string2 = String.format("\"%s\"", Encoding.encodeHex(Encoding.sha256(string, StandardCharsets.UTF_8)));
        return httpServerExchange -> {
            String string3 = httpServerExchange.getRequestHeader("If-None-Match");
            if (string2.equals(string3)) {
                ResponseBuilder.respond(httpServerExchange).status(304).contentType(ContentType.text_html).send();
            } else {
                ResponseBuilder.respond(httpServerExchange).status(200).contentType(ContentType.text_html).cache(CacheControlStrategy.STORE_BUT_CHECK_SERVER).header("ETag", string2).send(string);
            }
        };
    }

    public static boolean matchesEtag(HttpServerExchange httpServerExchange, String string) {
        return string.equals(httpServerExchange.getRequestHeader("If-None-Match"));
    }

    public static void checkEtag(String string, HttpServerExchange httpServerExchange, HttpHandler httpHandler) throws Exception {
        if (Common.matchesEtag(httpServerExchange, string)) {
            ResponseBuilder.respond(httpServerExchange).status(304).send();
            return;
        }
        httpHandler.handleRequest(httpServerExchange);
    }

    public static HttpHandler html404(String string) {
        return httpServerExchange -> ResponseBuilder.respond(httpServerExchange).status(404).cache(CacheControlStrategy.NEVER_CACHE).contentType(ContentType.text_html).send(string);
    }

    public static HttpHandler statusCode(int n) {
        return httpServerExchange -> httpServerExchange.setStatusCode(n);
    }

    public static HttpHandler redirect(String string) {
        return httpServerExchange -> ResponseBuilder.respond(httpServerExchange).status(302).header("Location", string).send();
    }

    public static HttpHandler noSuchApiEndpoint() {
        return httpServerExchange -> HttpError.respondError(httpServerExchange, 400, 400, "No such API endpoint");
    }

    public static HttpHandler securityHeaders(boolean bl, HttpHandler httpHandler) {
        return httpServerExchange -> {
            if (bl) {
                httpServerExchange.setResponseHeader("Strict-Transport-Security", "max-age=31536000; includeSubDomains");
                httpServerExchange.setResponseHeader("Cross-Origin-Opener-Policy", "same-origin");
            }
            httpServerExchange.setResponseHeader("X-Frame-Options", "sameorigin");
            httpServerExchange.setResponseHeader("X-XSS-Protection", "1; mode=block");
            httpServerExchange.setResponseHeader("X-Content-Type-Options", "nosniff");
            httpServerExchange.setResponseHeader("Referrer-Policy", "no-referrer");
            httpHandler.handleRequest(httpServerExchange);
        };
    }

    private static /* synthetic */ Common[] $values() {
        return new Common[0];
    }

    static {
        $VALUES = Common.$values();
    }
}

