/*
 * Decompiled with CFR 0.152.
 */
package httpserver.net;

import httpserver.net.ConnectionHandler;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.util.concurrent.Executor;

public final class Connection {
    private boolean running = true;

    public Connection(Executor executor, Socket socket, ConnectionHandler connectionHandler) throws IOException {
        OutputStream outputStream = socket.getOutputStream();
        InputStream inputStream = socket.getInputStream();
        executor.execute(() -> {
            try (OutputStream outputStream2 = outputStream;
                 InputStream inputStream2 = inputStream;
                 Socket socket2 = socket;){
                while (this.running) {
                    connectionHandler.handleInput(socket, inputStream, outputStream);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
    }

    public void stop() {
        this.running = false;
    }

    public boolean isAlive() {
        return this.running;
    }
}

