/*
 * Decompiled with CFR 0.152.
 */
package com.github.codingdebugallday.extension;

import com.github.codingdebugallday.exceptions.PluginException;
import com.github.codingdebugallday.extension.AbstractExtension;
import com.github.codingdebugallday.extension.ExtensionFactory;
import com.github.codingdebugallday.factory.process.pipe.PluginPipeProcessorExtend;
import com.github.codingdebugallday.factory.process.pipe.classs.PluginClassGroupExtend;
import com.github.codingdebugallday.factory.process.post.PluginPostProcessorExtend;
import com.github.codingdebugallday.loader.PluginResourceLoader;
import com.github.codingdebugallday.utils.CommonUtils;
import com.github.codingdebugallday.utils.OrderPriority;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;

public class ExtensionInitializer {
    private static final Logger LOG = LoggerFactory.getLogger(ExtensionInitializer.class);
    private static final AtomicBoolean IS_INIT = new AtomicBoolean(false);
    private static final List<PluginResourceLoader> RESOURCE_LOADERS_EXTENDS = new ArrayList<PluginResourceLoader>();
    private static final List<PluginPipeProcessorExtend> PIPE_PROCESSOR_EXTENDS = new ArrayList<PluginPipeProcessorExtend>();
    private static final List<PluginClassGroupExtend> CLASS_GROUP_EXTENDS = new ArrayList<PluginClassGroupExtend>();
    private static final List<PluginPostProcessorExtend> POST_PROCESSOR_EXTENDS = new ArrayList<PluginPostProcessorExtend>();

    private ExtensionInitializer() {
    }

    public static synchronized void initialize(ApplicationContext applicationContext) {
        if (applicationContext == null) {
            LOG.error("ApplicationContext is null, cannot initialize");
            return;
        }
        if (IS_INIT.get()) {
            throw new PluginException("The extension has been initialized");
        }
        Map<String, AbstractExtension> pluginExtension = ExtensionFactory.getPluginExtension();
        for (Map.Entry<String, AbstractExtension> entry : pluginExtension.entrySet()) {
            AbstractExtension abstractExtension = entry.getValue();
            if (abstractExtension == null) continue;
            try {
                abstractExtension.initialize(applicationContext);
                ExtensionInitializer.initialize(abstractExtension, applicationContext);
            }
            catch (Exception e) {
                LOG.error("Plugin extension '{}' initialize exception. {}", new Object[]{abstractExtension.key(), e.getMessage(), e});
            }
        }
        IS_INIT.set(true);
    }

    private static void initialize(AbstractExtension abstractExtension, ApplicationContext applicationContext) {
        StringBuilder debug = new StringBuilder();
        String key = abstractExtension.key();
        debug.append("Plugin extension '").append(key).append("'").append(" are [");
        ExtensionInitializer.iteration(abstractExtension.getPluginResourceLoader(), pluginResourceLoader -> {
            RESOURCE_LOADERS_EXTENDS.add((PluginResourceLoader)pluginResourceLoader);
            debug.append(pluginResourceLoader.key()).append("\u3001");
        }, PluginResourceLoader::order);
        ExtensionInitializer.iteration(abstractExtension.getPluginPipeProcessor(applicationContext), pluginPipeProcessorExtend -> {
            PIPE_PROCESSOR_EXTENDS.add((PluginPipeProcessorExtend)pluginPipeProcessorExtend);
            debug.append(pluginPipeProcessorExtend.key()).append("\u3001");
        }, PluginPipeProcessorExtend::order);
        ExtensionInitializer.iteration(abstractExtension.getPluginClassGroup(applicationContext), pluginClassGroupExtend -> {
            CLASS_GROUP_EXTENDS.add((PluginClassGroupExtend)pluginClassGroupExtend);
            debug.append(pluginClassGroupExtend.key()).append("\u3001");
        }, null);
        ExtensionInitializer.iteration(abstractExtension.getPluginPostProcessor(applicationContext), pluginResourceLoader -> {
            POST_PROCESSOR_EXTENDS.add((PluginPostProcessorExtend)pluginResourceLoader);
            debug.append(pluginResourceLoader.key());
        }, PluginPostProcessorExtend::order);
        debug.append("] is registered");
        LOG.info("Plugin extension '{}' is registered", (Object)key);
        LOG.debug("{}", (Object)debug);
    }

    public static List<PluginResourceLoader> getResourceLoadersExtends() {
        return RESOURCE_LOADERS_EXTENDS;
    }

    public static List<PluginPipeProcessorExtend> getPipeProcessorExtends() {
        return PIPE_PROCESSOR_EXTENDS;
    }

    public static List<PluginClassGroupExtend> getClassGroupExtends() {
        return CLASS_GROUP_EXTENDS;
    }

    public static List<PluginPostProcessorExtend> getPostProcessorExtends() {
        return POST_PROCESSOR_EXTENDS;
    }

    private static <T> void iteration(List<T> list, Consumer<T> consumer, Function<T, OrderPriority> order) {
        if (list == null || list.isEmpty()) {
            return;
        }
        if (order != null) {
            list.stream().filter(Objects::nonNull).sorted(CommonUtils.orderPriority(order)).forEach(consumer);
        } else {
            for (T t : list) {
                if (t == null) continue;
                consumer.accept(t);
            }
        }
    }
}

