/*
 * Decompiled with CFR 0.152.
 */
package com.github.codingdebugallday.factory;

import com.github.codingdebugallday.enums.BuildTypeEnum;
import com.github.codingdebugallday.exceptions.PluginException;
import com.github.codingdebugallday.factory.PluginFactory;
import com.github.codingdebugallday.factory.PluginRegistryInfo;
import com.github.codingdebugallday.factory.process.pipe.PluginPipeProcessor;
import com.github.codingdebugallday.factory.process.pipe.PluginPipeProcessorFactory;
import com.github.codingdebugallday.factory.process.post.PluginPostProcessor;
import com.github.codingdebugallday.factory.process.post.PluginPostProcessorFactory;
import com.github.codingdebugallday.integration.listener.PluginListener;
import com.github.codingdebugallday.integration.listener.PluginListenerFactory;
import com.github.codingdebugallday.utils.AopUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.pf4j.PluginWrapper;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.GenericApplicationContext;

public class DefaultPluginFactory
implements PluginFactory {
    private final Map<String, PluginRegistryInfo> registerPluginInfoMap = new HashMap<String, PluginRegistryInfo>();
    private final GenericApplicationContext applicationContext;
    private final PluginPipeProcessor pluginPipeProcessor;
    private final PluginPostProcessor pluginPostProcessor;
    private final PluginListenerFactory pluginListenerFactory;
    private Integer buildType = BuildTypeEnum.BUILD.ordinal();
    private final List<PluginRegistryInfo> buildContainer = new ArrayList<PluginRegistryInfo>();

    public DefaultPluginFactory(ApplicationContext applicationContext) {
        this(applicationContext, null);
    }

    public DefaultPluginFactory(ApplicationContext applicationContext, PluginListenerFactory pluginListenerFactory) {
        this.pluginPipeProcessor = new PluginPipeProcessorFactory(applicationContext);
        this.pluginPostProcessor = new PluginPostProcessorFactory(applicationContext);
        this.applicationContext = (GenericApplicationContext)applicationContext;
        this.pluginListenerFactory = pluginListenerFactory == null ? new PluginListenerFactory() : pluginListenerFactory;
        AopUtils.registered(applicationContext);
    }

    @Override
    public void initialize() {
        this.pluginPipeProcessor.initialize();
        this.pluginPostProcessor.initialize();
    }

    @Override
    public synchronized PluginFactory register(PluginWrapper pluginWrapper) {
        if (pluginWrapper == null) {
            throw new IllegalArgumentException("Parameter:pluginWrapper cannot be null");
        }
        if (this.registerPluginInfoMap.containsKey(pluginWrapper.getPluginId())) {
            throw new PluginException("The plugin '" + pluginWrapper.getPluginId() + "' already exists, Can't register");
        }
        if (!this.buildContainer.isEmpty() && this.buildType.intValue() == BuildTypeEnum.UNREGISTER.ordinal()) {
            throw new PluginException("Unable to Registry operate. Because there's no build");
        }
        PluginRegistryInfo registerPluginInfo = new PluginRegistryInfo(pluginWrapper);
        AopUtils.resolveAop(pluginWrapper);
        try {
            this.pluginPipeProcessor.register(registerPluginInfo);
            this.registerPluginInfoMap.put(pluginWrapper.getPluginId(), registerPluginInfo);
            this.buildContainer.add(registerPluginInfo);
            DefaultPluginFactory defaultPluginFactory = this;
            return defaultPluginFactory;
        }
        catch (Exception e) {
            this.pluginListenerFactory.failure(pluginWrapper.getPluginId(), e);
            throw e;
        }
        finally {
            this.buildType = 1;
            AopUtils.recoverAop();
        }
    }

    @Override
    public synchronized PluginFactory unregister(String pluginId) {
        PluginRegistryInfo registerPluginInfo = this.registerPluginInfoMap.get(pluginId);
        if (registerPluginInfo == null) {
            throw new PluginException("Not found plugin '" + pluginId + "' registered");
        }
        if (!this.buildContainer.isEmpty() && this.buildType == 1) {
            throw new PluginException("Unable to unregister operate. Because there's no build");
        }
        try {
            this.pluginPipeProcessor.unregister(registerPluginInfo);
            this.buildContainer.add(registerPluginInfo);
            DefaultPluginFactory defaultPluginFactory = this;
            return defaultPluginFactory;
        }
        catch (Exception e) {
            this.pluginListenerFactory.failure(pluginId, e);
            throw e;
        }
        finally {
            this.registerPluginInfoMap.remove(pluginId);
            this.buildType = 2;
        }
    }

    @Override
    public synchronized void build() {
        if (this.buildContainer.isEmpty()) {
            throw new PluginException("No Found registered or unregistered plugin. Unable to build");
        }
        this.pluginListenerFactory.buildListenerClass(this.applicationContext);
        try {
            if (this.buildType == 1) {
                this.registryBuild();
            } else {
                this.unRegistryBuild();
            }
        }
        finally {
            this.buildContainer.clear();
            if (this.buildType == 1) {
                AopUtils.recoverAop();
            }
            this.buildType = 0;
        }
    }

    private void registryBuild() {
        this.pluginPostProcessor.register(this.buildContainer);
        for (PluginRegistryInfo pluginRegistryInfo : this.buildContainer) {
            this.pluginListenerFactory.register(pluginRegistryInfo.getPluginWrapper().getPluginId());
        }
    }

    private void unRegistryBuild() {
        this.pluginPostProcessor.unregister(this.buildContainer);
        for (PluginRegistryInfo pluginRegistryInfo : this.buildContainer) {
            this.pluginListenerFactory.unregister(pluginRegistryInfo.getPluginWrapper().getPluginId());
        }
    }

    @Override
    public void addListener(PluginListener pluginListener) {
        this.pluginListenerFactory.addPluginListener(pluginListener);
    }

    @Override
    public <T extends PluginListener> void addListener(Class<T> pluginListenerClass) {
        this.pluginListenerFactory.addPluginListener(pluginListenerClass);
    }

    @Override
    public void addListener(List<PluginListener> pluginListeners) {
        if (pluginListeners != null) {
            for (PluginListener pluginListener : pluginListeners) {
                this.pluginListenerFactory.addPluginListener(pluginListener);
            }
        }
    }
}

