/*
 * Decompiled with CFR 0.152.
 */
package com.github.codingdebugallday.factory;

import com.github.codingdebugallday.exceptions.PluginException;
import com.github.codingdebugallday.factory.PluginInfoContainer;
import com.github.codingdebugallday.factory.process.pipe.bean.name.PluginAnnotationBeanNameGenerator;
import java.text.MessageFormat;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.AnnotatedGenericBeanDefinition;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.GenericApplicationContext;

public class SpringBeanRegister {
    private static final Logger logger = LoggerFactory.getLogger(SpringBeanRegister.class);
    private final GenericApplicationContext applicationContext;

    public SpringBeanRegister(ApplicationContext applicationContext) {
        this.applicationContext = (GenericApplicationContext)applicationContext;
    }

    public String register(String pluginId, Class<?> aClass) {
        return this.register(pluginId, null, aClass, null);
    }

    public String register(String pluginId, String suffixName, Class<?> aClass) {
        return this.register(pluginId, suffixName, aClass, null);
    }

    public String register(String pluginId, Class<?> aClass, Consumer<AnnotatedGenericBeanDefinition> consumer) {
        return this.register(pluginId, null, aClass, consumer);
    }

    public String register(String pluginId, String suffixName, Class<?> aClass, Consumer<AnnotatedGenericBeanDefinition> consumer) {
        PluginAnnotationBeanNameGenerator beanNameGenerator = new PluginAnnotationBeanNameGenerator(pluginId, suffixName);
        AnnotatedGenericBeanDefinition beanDefinition = new AnnotatedGenericBeanDefinition(aClass);
        String beanName = beanNameGenerator.generateBeanName((BeanDefinition)beanDefinition, (BeanDefinitionRegistry)this.applicationContext);
        if (PluginInfoContainer.existRegisterBeanName(beanName)) {
            logger.debug("Bean name {} already exist of {}", (Object)beanName, (Object)aClass.getName());
            return beanName;
        }
        if (consumer != null) {
            consumer.accept(beanDefinition);
        }
        this.applicationContext.registerBeanDefinition(beanName, (BeanDefinition)beanDefinition);
        PluginInfoContainer.addRegisterBeanName(pluginId, beanName);
        return beanName;
    }

    public void registerOfSpecifyName(String pluginId, String beanName, Class<?> aClass) {
        this.registerOfSpecifyName(pluginId, beanName, aClass, null);
    }

    public void registerOfSpecifyName(String pluginId, String beanName, Class<?> aClass, Consumer<AnnotatedGenericBeanDefinition> consumer) {
        AnnotatedGenericBeanDefinition beanDefinition = new AnnotatedGenericBeanDefinition(aClass);
        if (PluginInfoContainer.existRegisterBeanName(beanName)) {
            String error = MessageFormat.format("Bean name {0} already exist of {1}", beanName, aClass.getName());
            throw new PluginException(error);
        }
        if (consumer != null) {
            consumer.accept(beanDefinition);
        }
        PluginInfoContainer.addRegisterBeanName(pluginId, beanName);
        this.applicationContext.registerBeanDefinition(beanName, (BeanDefinition)beanDefinition);
    }

    public void unregister(String pluginId, String beanName) {
        PluginInfoContainer.removeRegisterBeanName(pluginId, beanName);
        this.applicationContext.removeBeanDefinition(beanName);
    }
}

