/*
 * Decompiled with CFR 0.152.
 */
package com.github.codingdebugallday.factory.process.pipe;

import com.github.codingdebugallday.extension.ExtensionInitializer;
import com.github.codingdebugallday.factory.PluginRegistryInfo;
import com.github.codingdebugallday.factory.process.pipe.PluginPipeProcessor;
import com.github.codingdebugallday.factory.process.pipe.bean.BasicBeanProcessor;
import com.github.codingdebugallday.factory.process.pipe.bean.ConfigBeanProcessor;
import com.github.codingdebugallday.factory.process.pipe.bean.ConfigFileBeanProcessor;
import com.github.codingdebugallday.factory.process.pipe.bean.OneselfListenerStopEventProcessor;
import com.github.codingdebugallday.factory.process.pipe.classs.PluginClassProcess;
import java.util.ArrayList;
import java.util.List;
import org.springframework.context.ApplicationContext;

public class PluginPipeProcessorFactory
implements PluginPipeProcessor {
    private final ApplicationContext applicationContext;
    private final List<PluginPipeProcessor> pluginPipeProcessors = new ArrayList<PluginPipeProcessor>();

    public PluginPipeProcessorFactory(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    @Override
    public void initialize() {
        this.pluginPipeProcessors.add(new OneselfListenerStopEventProcessor(this.applicationContext));
        this.pluginPipeProcessors.add(new PluginClassProcess());
        this.pluginPipeProcessors.add(new ConfigFileBeanProcessor(this.applicationContext));
        this.pluginPipeProcessors.add(new ConfigBeanProcessor(this.applicationContext));
        this.pluginPipeProcessors.add(new BasicBeanProcessor(this.applicationContext));
        this.pluginPipeProcessors.addAll(ExtensionInitializer.getPipeProcessorExtends());
        for (PluginPipeProcessor pluginPipeProcessor : this.pluginPipeProcessors) {
            pluginPipeProcessor.initialize();
        }
    }

    @Override
    public void register(PluginRegistryInfo pluginRegistryInfo) {
        for (PluginPipeProcessor pluginPipeProcessor : this.pluginPipeProcessors) {
            pluginPipeProcessor.register(pluginRegistryInfo);
        }
    }

    @Override
    public void unregister(PluginRegistryInfo pluginRegistryInfo) {
        for (PluginPipeProcessor pluginPipeProcessor : this.pluginPipeProcessors) {
            pluginPipeProcessor.unregister(pluginRegistryInfo);
        }
    }
}

