/*
 * Decompiled with CFR 0.152.
 */
package com.github.codingdebugallday.factory.process.pipe.bean;

import com.github.codingdebugallday.factory.PluginRegistryInfo;
import com.github.codingdebugallday.factory.SpringBeanRegister;
import com.github.codingdebugallday.factory.process.pipe.PluginPipeProcessor;
import com.github.codingdebugallday.utils.GlobalRegistryInfo;
import com.github.codingdebugallday.utils.PluginOperatorInfo;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.springframework.aop.framework.autoproxy.BeanFactoryAdvisorRetrievalHelper;
import org.springframework.aop.support.AopUtils;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.context.ApplicationContext;

public class BasicBeanProcessor
implements PluginPipeProcessor {
    private static final String KEY = "BasicBeanProcessor";
    private static final String AOP_BEAN_NAME_INC_NUM = "AOP_BEAN_NAME_INC_NUM";
    private final SpringBeanRegister springBeanRegister;
    private final BeanFactoryAdvisorRetrievalHelper helper;

    public BasicBeanProcessor(ApplicationContext applicationContext) {
        Objects.requireNonNull(applicationContext);
        this.springBeanRegister = new SpringBeanRegister(applicationContext);
        this.helper = new BeanFactoryAdvisorRetrievalHelper((ConfigurableListableBeanFactory)applicationContext.getAutowireCapableBeanFactory());
    }

    @Override
    public void initialize() {
    }

    @Override
    public void register(PluginRegistryInfo pluginRegistryInfo) {
        HashSet<String> beanNames = new HashSet<String>();
        List<Class<?>> springComponents = pluginRegistryInfo.getGroupClasses("spring_component");
        List<Class<?>> springConfigurations = pluginRegistryInfo.getGroupClasses("spring_configuration");
        List<Class<?>> springRepository = pluginRegistryInfo.getGroupClasses("spring_repository");
        List<Class<?>> oneselfListener = pluginRegistryInfo.getGroupClasses("oneself_listener");
        this.register(pluginRegistryInfo, springComponents, beanNames);
        this.register(pluginRegistryInfo, springConfigurations, beanNames);
        this.register(pluginRegistryInfo, springRepository, beanNames);
        this.register(pluginRegistryInfo, oneselfListener, beanNames);
        pluginRegistryInfo.addProcessorInfo(KEY, beanNames);
    }

    @Override
    public void unregister(PluginRegistryInfo pluginRegistryInfo) {
        Set beanNames = (Set)pluginRegistryInfo.getProcessorInfo(KEY);
        String pluginId = pluginRegistryInfo.getPluginWrapper().getPluginId();
        if (beanNames != null) {
            for (String beanName : beanNames) {
                this.springBeanRegister.unregister(pluginId, beanName);
            }
        }
    }

    private void register(PluginRegistryInfo pluginRegistryInfo, List<Class<?>> classes, Set<String> beanNames) {
        if (classes == null || classes.isEmpty()) {
            return;
        }
        String pluginId = pluginRegistryInfo.getPluginWrapper().getPluginId();
        for (Class<?> aClass : classes) {
            if (aClass == null) continue;
            String namePrefix = this.resolveAopClass(pluginId, aClass);
            String beanName = this.springBeanRegister.register(pluginId, namePrefix, aClass);
            beanNames.add(beanName);
        }
    }

    private String resolveAopClass(String pluginId, Class<?> aClass) {
        AtomicInteger atomicInteger;
        PluginOperatorInfo operatorPluginInfo = GlobalRegistryInfo.getPluginInstallNum(pluginId);
        if (operatorPluginInfo == null) {
            return null;
        }
        List advisorBeans = this.helper.findAdvisorBeans();
        List advisorsThatCanApply = AopUtils.findAdvisorsThatCanApply((List)advisorBeans, aClass);
        if (advisorsThatCanApply.isEmpty()) {
            return null;
        }
        Object o = GlobalRegistryInfo.getExtension(AOP_BEAN_NAME_INC_NUM);
        if (o instanceof AtomicInteger) {
            atomicInteger = (AtomicInteger)o;
        } else {
            atomicInteger = new AtomicInteger(-1);
            GlobalRegistryInfo.addExtension(AOP_BEAN_NAME_INC_NUM, atomicInteger);
        }
        PluginOperatorInfo.OperatorType operatorType = operatorPluginInfo.getOperatorType();
        if (operatorType == PluginOperatorInfo.OperatorType.INSTALL) {
            return String.valueOf(atomicInteger.incrementAndGet());
        }
        return String.valueOf(atomicInteger.get());
    }
}

