/*
 * Decompiled with CFR 0.152.
 */
package com.github.codingdebugallday.factory.process.pipe.bean;

import com.github.codingdebugallday.factory.PluginRegistryInfo;
import com.github.codingdebugallday.factory.process.pipe.PluginPipeProcessor;
import com.github.codingdebugallday.integration.application.PluginApplication;
import com.github.codingdebugallday.integration.user.PluginUser;
import com.github.codingdebugallday.realize.BasePlugin;
import com.github.codingdebugallday.realize.OneselfListener;
import com.github.codingdebugallday.utils.CommonUtils;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;

public class OneselfListenerStopEventProcessor
implements PluginPipeProcessor {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final PluginUser pluginUser;

    public OneselfListenerStopEventProcessor(ApplicationContext applicationContext) {
        Objects.requireNonNull(applicationContext);
        PluginApplication pluginApplication = (PluginApplication)applicationContext.getBean(PluginApplication.class);
        this.pluginUser = pluginApplication.getPluginUser();
    }

    @Override
    public void initialize() {
    }

    @Override
    public void register(PluginRegistryInfo pluginRegistryInfo) {
    }

    @Override
    public void unregister(PluginRegistryInfo pluginRegistryInfo) {
        BasePlugin basePlugin = pluginRegistryInfo.getBasePlugin();
        String pluginId = basePlugin.getWrapper().getPluginId();
        List<OneselfListener> oneselfListeners = this.pluginUser.getPluginBeans(pluginId, OneselfListener.class);
        oneselfListeners.stream().sorted(CommonUtils.orderPriority(OneselfListener::order)).forEach(oneselfListener -> {
            try {
                oneselfListener.stopEvent(basePlugin);
            }
            catch (Exception e) {
                this.log.error("OneselfListener {} execute stopEvent exception. {}", new Object[]{oneselfListener.getClass().getName(), e.getMessage(), e});
            }
        });
    }
}

