/*
 * Decompiled with CFR 0.152.
 */
package com.github.codingdebugallday.factory.process.pipe.bean.configuration;

import com.github.codingdebugallday.exceptions.PluginException;
import com.github.codingdebugallday.factory.process.pipe.bean.configuration.ConfigurationParser;
import com.github.codingdebugallday.factory.process.pipe.bean.configuration.PluginConfigDefinition;
import com.github.codingdebugallday.integration.IntegrationConfiguration;
import com.github.codingdebugallday.loader.ResourceWrapper;
import com.github.codingdebugallday.loader.load.PluginConfigFileLoader;
import com.github.codingdebugallday.realize.BasePlugin;
import java.util.List;
import java.util.Objects;
import org.springframework.core.io.Resource;
import org.springframework.util.CollectionUtils;

public abstract class AbstractConfigurationParser
implements ConfigurationParser {
    private final IntegrationConfiguration configuration;

    public AbstractConfigurationParser(IntegrationConfiguration configuration) {
        Objects.requireNonNull(configuration);
        this.configuration = configuration;
    }

    @Override
    public Object parse(BasePlugin basePlugin, PluginConfigDefinition pluginConfigDefinition) {
        Class<?> configClass = pluginConfigDefinition.getConfigClass();
        if (pluginConfigDefinition.getConfigClass() == null) {
            throw new IllegalArgumentException("pluginConfigDefinition : " + pluginConfigDefinition + " configClass can not be null");
        }
        String fileName = pluginConfigDefinition.getFileName();
        if (pluginConfigDefinition.getFileName() == null || "".equals(pluginConfigDefinition.getFileName())) {
            throw new IllegalArgumentException("pluginConfigDefinition : " + pluginConfigDefinition + " fileName can not be empty");
        }
        PluginConfigFileLoader resourceLoader = new PluginConfigFileLoader(this.configuration.pluginConfigFilePath(), fileName);
        ResourceWrapper resourceWrapper = resourceLoader.load(basePlugin);
        if (resourceWrapper == null) {
            return null;
        }
        List<Resource> resources = resourceWrapper.getResources();
        if (CollectionUtils.isEmpty(resources) || resources.size() != 1) {
            return null;
        }
        Object o = this.parse(resources.get(0), configClass);
        if (o == null) {
            try {
                return configClass.newInstance();
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new PluginException(e);
            }
        }
        return o;
    }

    protected abstract Object parse(Resource var1, Class<?> var2);
}

